@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Property definition.
 * @property arrayValueSeparator Array value separator for properties with isArray set.
 * @property dataSourcePrecedenceRules This is specific to interactions modeled as activities. Data sources are used to determine where data is stored and also in precedence rules.
 * @property enumValidValues Describes valid values for an enum property.
 * @property fieldName Name of the property.
 * @property fieldType Type of the property.
 * @property isArray Indicates if the property is actually an array of the fieldType above on the data api.
 * @property isAvailableInGraph Whether property is available in graph or not.
 * @property isEnum Indicates if the property is an enum.
 * @property isFlagEnum Indicates if the property is an flag enum.
 * @property isImage Whether the property is an Image.
 * @property isLocalizedString Whether the property is a localized string.
 * @property isName Whether the property is a name or a part of name.
 * @property isRequired Whether property value is required on instances, IsRequired field only for Interaction. Profile Instance will not check for required field.
 * @property maxLength Max length of string. Used only if type is string.
 * @property propertyId The ID associated with the property.
 * @property schemaItemPropLink URL encoded schema.org item prop link for the property.
 */
public data class PropertyDefinitionResponse(
    public val arrayValueSeparator: String? = null,
    public val dataSourcePrecedenceRules: List<DataSourcePrecedenceResponse>,
    public val enumValidValues: List<ProfileEnumValidValuesFormatResponse>? = null,
    public val fieldName: String,
    public val fieldType: String,
    public val isArray: Boolean? = null,
    public val isAvailableInGraph: Boolean? = null,
    public val isEnum: Boolean? = null,
    public val isFlagEnum: Boolean? = null,
    public val isImage: Boolean? = null,
    public val isLocalizedString: Boolean? = null,
    public val isName: Boolean? = null,
    public val isRequired: Boolean? = null,
    public val maxLength: Int? = null,
    public val propertyId: String? = null,
    public val schemaItemPropLink: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.PropertyDefinitionResponse):
            PropertyDefinitionResponse = PropertyDefinitionResponse(
            arrayValueSeparator = javaType.arrayValueSeparator().map({ args0 -> args0 }).orElse(null),
            dataSourcePrecedenceRules = javaType.dataSourcePrecedenceRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.DataSourcePrecedenceResponse.Companion.toKotlin(args0)
                })
            }),
            enumValidValues = javaType.enumValidValues().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.ProfileEnumValidValuesFormatResponse.Companion.toKotlin(args0)
                })
            }),
            fieldName = javaType.fieldName(),
            fieldType = javaType.fieldType(),
            isArray = javaType.isArray().map({ args0 -> args0 }).orElse(null),
            isAvailableInGraph = javaType.isAvailableInGraph().map({ args0 -> args0 }).orElse(null),
            isEnum = javaType.isEnum().map({ args0 -> args0 }).orElse(null),
            isFlagEnum = javaType.isFlagEnum().map({ args0 -> args0 }).orElse(null),
            isImage = javaType.isImage().map({ args0 -> args0 }).orElse(null),
            isLocalizedString = javaType.isLocalizedString().map({ args0 -> args0 }).orElse(null),
            isName = javaType.isName().map({ args0 -> args0 }).orElse(null),
            isRequired = javaType.isRequired().map({ args0 -> args0 }).orElse(null),
            maxLength = javaType.maxLength().map({ args0 -> args0 }).orElse(null),
            propertyId = javaType.propertyId().map({ args0 -> args0 }).orElse(null),
            schemaItemPropLink = javaType.schemaItemPropLink().map({ args0 -> args0 }).orElse(null),
        )
    }
}
