@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customproviders.kotlin

import com.pulumi.azurenative.customproviders.AssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The resource definition of this association.
 * Azure REST API version: 2018-09-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * ## Example Usage
 * ### Create or update an association
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var association = new AzureNative.CustomProviders.Association("association", new()
 *     {
 *         AssociationName = "associationName",
 *         Scope = "scope",
 *         TargetResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/appRG/providers/Microsoft.Solutions/applications/applicationName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customproviders/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customproviders.NewAssociation(ctx, "association", &customproviders.AssociationArgs{
 * 			AssociationName:  pulumi.String("associationName"),
 * 			Scope:            pulumi.String("scope"),
 * 			TargetResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/appRG/providers/Microsoft.Solutions/applications/applicationName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customproviders.Association;
 * import com.pulumi.azurenative.customproviders.AssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var association = new Association("association", AssociationArgs.builder()
 *             .associationName("associationName")
 *             .scope("scope")
 *             .targetResourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/appRG/providers/Microsoft.Solutions/applications/applicationName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customproviders:Association associationName /{scope}/providers/Microsoft.CustomProviders/associations/{associationName}
 * ```
 * @property associationName The name of the association.
 * @property scope The scope of the association. The scope can be any valid REST resource instance. For example, use '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/Microsoft.Compute/virtualMachines/{vm-name}' for a virtual machine resource.
 * @property targetResourceId The REST resource instance of the target resource for this association.
 */
public data class AssociationArgs(
    public val associationName: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val targetResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.customproviders.AssociationArgs> {
    override fun toJava(): com.pulumi.azurenative.customproviders.AssociationArgs =
        com.pulumi.azurenative.customproviders.AssociationArgs.builder()
            .associationName(associationName?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .targetResourceId(targetResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssociationArgs].
 */
@PulumiTagMarker
public class AssociationArgsBuilder internal constructor() {
    private var associationName: Output<String>? = null

    private var scope: Output<String>? = null

    private var targetResourceId: Output<String>? = null

    /**
     * @param value The name of the association.
     */
    @JvmName("irxkvkuhwyrordgn")
    public suspend fun associationName(`value`: Output<String>) {
        this.associationName = value
    }

    /**
     * @param value The scope of the association. The scope can be any valid REST resource instance. For example, use '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/Microsoft.Compute/virtualMachines/{vm-name}' for a virtual machine resource.
     */
    @JvmName("qquukkhgkgixnyra")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The REST resource instance of the target resource for this association.
     */
    @JvmName("sdmyklgjbtylahxp")
    public suspend fun targetResourceId(`value`: Output<String>) {
        this.targetResourceId = value
    }

    /**
     * @param value The name of the association.
     */
    @JvmName("ppdnpbhobdtypkko")
    public suspend fun associationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associationName = mapped
    }

    /**
     * @param value The scope of the association. The scope can be any valid REST resource instance. For example, use '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/Microsoft.Compute/virtualMachines/{vm-name}' for a virtual machine resource.
     */
    @JvmName("qvswtftcyfkveksx")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The REST resource instance of the target resource for this association.
     */
    @JvmName("tireryyldyhxysod")
    public suspend fun targetResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceId = mapped
    }

    internal fun build(): AssociationArgs = AssociationArgs(
        associationName = associationName,
        scope = scope,
        targetResourceId = targetResourceId,
    )
}
