@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customproviders.kotlin.inputs

import com.pulumi.azurenative.customproviders.inputs.CustomRPResourceTypeRouteDefinitionArgs.builder
import com.pulumi.azurenative.customproviders.kotlin.enums.ResourceTypeRouting
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The route definition for a resource implemented by the custom resource provider.
 * @property endpoint The route definition endpoint URI that the custom resource provider will proxy requests to. This can be in the form of a flat URI (e.g. 'https://testendpoint/') or can specify to route via a path (e.g. 'https://testendpoint/{requestPath}')
 * @property name The name of the route definition. This becomes the name for the ARM extension (e.g. '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomProviders/resourceProviders/{resourceProviderName}/{name}')
 * @property routingType The routing types that are supported for resource requests.
 */
public data class CustomRPResourceTypeRouteDefinitionArgs(
    public val endpoint: Output<String>,
    public val name: Output<String>,
    public val routingType: Output<Either<String, ResourceTypeRouting>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.customproviders.inputs.CustomRPResourceTypeRouteDefinitionArgs> {
    override fun toJava():
        com.pulumi.azurenative.customproviders.inputs.CustomRPResourceTypeRouteDefinitionArgs =
        com.pulumi.azurenative.customproviders.inputs.CustomRPResourceTypeRouteDefinitionArgs.builder()
            .endpoint(endpoint.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .routingType(
                routingType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [CustomRPResourceTypeRouteDefinitionArgs].
 */
@PulumiTagMarker
public class CustomRPResourceTypeRouteDefinitionArgsBuilder internal constructor() {
    private var endpoint: Output<String>? = null

    private var name: Output<String>? = null

    private var routingType: Output<Either<String, ResourceTypeRouting>>? = null

    /**
     * @param value The route definition endpoint URI that the custom resource provider will proxy requests to. This can be in the form of a flat URI (e.g. 'https://testendpoint/') or can specify to route via a path (e.g. 'https://testendpoint/{requestPath}')
     */
    @JvmName("ekphmnxkubnrvejd")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value The name of the route definition. This becomes the name for the ARM extension (e.g. '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomProviders/resourceProviders/{resourceProviderName}/{name}')
     */
    @JvmName("jopnwpefgiwhmupv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The routing types that are supported for resource requests.
     */
    @JvmName("exudtvfvxbgvmycm")
    public suspend fun routingType(`value`: Output<Either<String, ResourceTypeRouting>>) {
        this.routingType = value
    }

    /**
     * @param value The route definition endpoint URI that the custom resource provider will proxy requests to. This can be in the form of a flat URI (e.g. 'https://testendpoint/') or can specify to route via a path (e.g. 'https://testendpoint/{requestPath}')
     */
    @JvmName("rwylopmcbavggtrq")
    public suspend fun endpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value The name of the route definition. This becomes the name for the ARM extension (e.g. '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomProviders/resourceProviders/{resourceProviderName}/{name}')
     */
    @JvmName("ilkbdbaymixwmkfo")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The routing types that are supported for resource requests.
     */
    @JvmName("ggrkbwfqvyngfxdr")
    public suspend fun routingType(`value`: Either<String, ResourceTypeRouting>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingType = mapped
    }

    /**
     * @param value The routing types that are supported for resource requests.
     */
    @JvmName("vorawdyfukjccdlb")
    public fun routingType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ResourceTypeRouting>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingType = mapped
    }

    /**
     * @param value The routing types that are supported for resource requests.
     */
    @JvmName("qpvfiawjvaxmxbut")
    public fun routingType(`value`: ResourceTypeRouting) {
        val toBeMapped = Either.ofRight<String, ResourceTypeRouting>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingType = mapped
    }

    internal fun build(): CustomRPResourceTypeRouteDefinitionArgs =
        CustomRPResourceTypeRouteDefinitionArgs(
            endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
            name = name ?: throw PulumiNullFieldException("name"),
            routingType = routingType,
        )
}
