@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customproviders.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A validation to apply on custom resource provider requests.
 * @property specification A link to the validation specification. The specification must be hosted on raw.githubusercontent.com.
 * @property validationType The type of validation to run against a matching request.
 */
public data class CustomRPValidationsResponse(
    public val specification: String,
    public val validationType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.customproviders.outputs.CustomRPValidationsResponse):
            CustomRPValidationsResponse = CustomRPValidationsResponse(
            specification = javaType.specification(),
            validationType = javaType.validationType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
