@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dashboard.kotlin

import com.pulumi.azurenative.dashboard.GrafanaArgs.builder
import com.pulumi.azurenative.dashboard.kotlin.inputs.ManagedGrafanaPropertiesArgs
import com.pulumi.azurenative.dashboard.kotlin.inputs.ManagedGrafanaPropertiesArgsBuilder
import com.pulumi.azurenative.dashboard.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.dashboard.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.dashboard.kotlin.inputs.ResourceSkuArgs
import com.pulumi.azurenative.dashboard.kotlin.inputs.ResourceSkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The grafana resource type.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2022-05-01-preview.
 * Other available API versions: 2021-09-01-preview, 2022-10-01-preview, 2023-09-01.
 * ## Example Usage
 * ### Grafana_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var grafana = new AzureNative.Dashboard.Grafana("grafana", new()
 *     {
 *         Identity = new AzureNative.Dashboard.Inputs.ManagedServiceIdentityArgs
 *         {
 *             Type = "SystemAssigned",
 *         },
 *         Location = "West US",
 *         Properties = new AzureNative.Dashboard.Inputs.ManagedGrafanaPropertiesArgs
 *         {
 *             ApiKey = "Enabled",
 *             DeterministicOutboundIP = "Enabled",
 *             GrafanaIntegrations = new AzureNative.Dashboard.Inputs.GrafanaIntegrationsArgs
 *             {
 *                 AzureMonitorWorkspaceIntegrations = new[]
 *                 {
 *                     new AzureNative.Dashboard.Inputs.AzureMonitorWorkspaceIntegrationArgs
 *                     {
 *                         AzureMonitorWorkspaceResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace",
 *                     },
 *                 },
 *             },
 *             PublicNetworkAccess = "Enabled",
 *             ZoneRedundancy = "Enabled",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Dashboard.Inputs.ResourceSkuArgs
 *         {
 *             Name = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "Environment", "Dev" },
 *         },
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dashboard/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := dashboard.NewGrafana(ctx, "grafana", &dashboard.GrafanaArgs{
 * Identity: &dashboard.ManagedServiceIdentityArgs{
 * Type: pulumi.String("SystemAssigned"),
 * },
 * Location: pulumi.String("West US"),
 * Properties: dashboard.ManagedGrafanaPropertiesResponse{
 * ApiKey: pulumi.String("Enabled"),
 * DeterministicOutboundIP: pulumi.String("Enabled"),
 * GrafanaIntegrations: interface{}{
 * AzureMonitorWorkspaceIntegrations: dashboard.AzureMonitorWorkspaceIntegrationArray{
 * &dashboard.AzureMonitorWorkspaceIntegrationArgs{
 * AzureMonitorWorkspaceResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace"),
 * },
 * },
 * },
 * PublicNetworkAccess: pulumi.String("Enabled"),
 * ZoneRedundancy: pulumi.String("Enabled"),
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * Sku: &dashboard.ResourceSkuArgs{
 * Name: pulumi.String("Standard"),
 * },
 * Tags: pulumi.StringMap{
 * "Environment": pulumi.String("Dev"),
 * },
 * WorkspaceName: pulumi.String("myWorkspace"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dashboard.Grafana;
 * import com.pulumi.azurenative.dashboard.GrafanaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var grafana = new Grafana("grafana", GrafanaArgs.builder()
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .location("West US")
 *             .properties(Map.ofEntries(
 *                 Map.entry("apiKey", "Enabled"),
 *                 Map.entry("deterministicOutboundIP", "Enabled"),
 *                 Map.entry("grafanaIntegrations", Map.of("azureMonitorWorkspaceIntegrations", Map.of("azureMonitorWorkspaceResourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace"))),
 *                 Map.entry("publicNetworkAccess", "Enabled"),
 *                 Map.entry("zoneRedundancy", "Enabled")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .sku(Map.of("name", "Standard"))
 *             .tags(Map.of("Environment", "Dev"))
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dashboard:Grafana myWorkspace /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}
 * ```
 * @property identity The managed identity of the grafana resource.
 * @property location The geo-location where the grafana resource lives
 * @property properties Properties specific to the grafana resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku The Sku of the grafana resource.
 * @property tags The tags for grafana resource.
 * @property workspaceName The workspace name of Azure Managed Grafana.
 */
public data class GrafanaArgs(
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<ManagedGrafanaPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<ResourceSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dashboard.GrafanaArgs> {
    override fun toJava(): com.pulumi.azurenative.dashboard.GrafanaArgs =
        com.pulumi.azurenative.dashboard.GrafanaArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GrafanaArgs].
 */
@PulumiTagMarker
public class GrafanaArgsBuilder internal constructor() {
    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var properties: Output<ManagedGrafanaPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<ResourceSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The managed identity of the grafana resource.
     */
    @JvmName("isbfukeetibsnimt")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the grafana resource lives
     */
    @JvmName("qxolxfcnjwonrucb")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties specific to the grafana resource.
     */
    @JvmName("itpdoxjmpjyryrml")
    public suspend fun properties(`value`: Output<ManagedGrafanaPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pldvnuscjqxkrwsy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Sku of the grafana resource.
     */
    @JvmName("htwpoeemilotxaqi")
    public suspend fun sku(`value`: Output<ResourceSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The tags for grafana resource.
     */
    @JvmName("wbmbupwuulvtfirk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The workspace name of Azure Managed Grafana.
     */
    @JvmName("oxkddywpbofsoldl")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The managed identity of the grafana resource.
     */
    @JvmName("yopptokceotxilck")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The managed identity of the grafana resource.
     */
    @JvmName("frhynjfkmhnondro")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the grafana resource lives
     */
    @JvmName("ykvefvastmaeibja")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties specific to the grafana resource.
     */
    @JvmName("fhqtdivwdartrkcj")
    public suspend fun properties(`value`: ManagedGrafanaPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties specific to the grafana resource.
     */
    @JvmName("mwiautbyurwlhqwb")
    public suspend fun properties(argument: suspend ManagedGrafanaPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedGrafanaPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ibtesijggurofjwi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Sku of the grafana resource.
     */
    @JvmName("elfnypcrjkjhqlwa")
    public suspend fun sku(`value`: ResourceSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The Sku of the grafana resource.
     */
    @JvmName("ijcycqdehtnlptye")
    public suspend fun sku(argument: suspend ResourceSkuArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The tags for grafana resource.
     */
    @JvmName("wgpemlxmpshnaive")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags for grafana resource.
     */
    @JvmName("dieithsyhnyqyvxj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The workspace name of Azure Managed Grafana.
     */
    @JvmName("wcseetvjvcepdprl")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): GrafanaArgs = GrafanaArgs(
        identity = identity,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        workspaceName = workspaceName,
    )
}
