@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dashboard.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The api key setting of the Grafana instance.
 */
public enum class ApiKey(
    public val javaValue: com.pulumi.azurenative.dashboard.enums.ApiKey,
) : ConvertibleToJava<com.pulumi.azurenative.dashboard.enums.ApiKey> {
    Disabled(com.pulumi.azurenative.dashboard.enums.ApiKey.Disabled),
    Enabled(com.pulumi.azurenative.dashboard.enums.ApiKey.Enabled),
    ;

    override fun toJava(): com.pulumi.azurenative.dashboard.enums.ApiKey = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dashboard.enums.ApiKey): ApiKey =
            ApiKey.values().first { it.javaValue == javaType }
    }
}
