@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dashboard.kotlin.inputs

import com.pulumi.azurenative.dashboard.inputs.AzureMonitorWorkspaceIntegrationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Integrations for Azure Monitor Workspace.
 * @property azureMonitorWorkspaceResourceId The resource Id of the connected Azure Monitor Workspace.
 */
public data class AzureMonitorWorkspaceIntegrationArgs(
    public val azureMonitorWorkspaceResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dashboard.inputs.AzureMonitorWorkspaceIntegrationArgs> {
    override fun toJava():
        com.pulumi.azurenative.dashboard.inputs.AzureMonitorWorkspaceIntegrationArgs =
        com.pulumi.azurenative.dashboard.inputs.AzureMonitorWorkspaceIntegrationArgs.builder()
            .azureMonitorWorkspaceResourceId(
                azureMonitorWorkspaceResourceId?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [AzureMonitorWorkspaceIntegrationArgs].
 */
@PulumiTagMarker
public class AzureMonitorWorkspaceIntegrationArgsBuilder internal constructor() {
    private var azureMonitorWorkspaceResourceId: Output<String>? = null

    /**
     * @param value The resource Id of the connected Azure Monitor Workspace.
     */
    @JvmName("gvwidwepqjjcclut")
    public suspend fun azureMonitorWorkspaceResourceId(`value`: Output<String>) {
        this.azureMonitorWorkspaceResourceId = value
    }

    /**
     * @param value The resource Id of the connected Azure Monitor Workspace.
     */
    @JvmName("crfdpvyvmqmgrpmb")
    public suspend fun azureMonitorWorkspaceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureMonitorWorkspaceResourceId = mapped
    }

    internal fun build(): AzureMonitorWorkspaceIntegrationArgs = AzureMonitorWorkspaceIntegrationArgs(
        azureMonitorWorkspaceResourceId = azureMonitorWorkspaceResourceId,
    )
}
