@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dashboard.kotlin.inputs

import com.pulumi.azurenative.dashboard.inputs.GetManagedPrivateEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managedPrivateEndpointName The managed private endpoint name of Azure Managed Grafana.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The workspace name of Azure Managed Grafana.
 */
public data class GetManagedPrivateEndpointPlainArgs(
    public val managedPrivateEndpointName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.dashboard.inputs.GetManagedPrivateEndpointPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.dashboard.inputs.GetManagedPrivateEndpointPlainArgs =
        com.pulumi.azurenative.dashboard.inputs.GetManagedPrivateEndpointPlainArgs.builder()
            .managedPrivateEndpointName(managedPrivateEndpointName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedPrivateEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetManagedPrivateEndpointPlainArgsBuilder internal constructor() {
    private var managedPrivateEndpointName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The managed private endpoint name of Azure Managed Grafana.
     */
    @JvmName("lnryioaliuakveay")
    public suspend fun managedPrivateEndpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedPrivateEndpointName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("movmwmnqnccupdwk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The workspace name of Azure Managed Grafana.
     */
    @JvmName("gpnbwgddmbgruqhd")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetManagedPrivateEndpointPlainArgs = GetManagedPrivateEndpointPlainArgs(
        managedPrivateEndpointName = managedPrivateEndpointName ?: throw
            PulumiNullFieldException("managedPrivateEndpointName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
