@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dashboard.kotlin.inputs

import com.pulumi.azurenative.dashboard.inputs.GrafanaIntegrationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * GrafanaIntegrations is a bundled observability experience (e.g. pre-configured data source, tailored Grafana dashboards, alerting defaults) for common monitoring scenarios.
 * @property azureMonitorWorkspaceIntegrations
 */
public data class GrafanaIntegrationsArgs(
    public val azureMonitorWorkspaceIntegrations: Output<List<AzureMonitorWorkspaceIntegrationArgs>>? =
        null,
) : ConvertibleToJava<com.pulumi.azurenative.dashboard.inputs.GrafanaIntegrationsArgs> {
    override fun toJava(): com.pulumi.azurenative.dashboard.inputs.GrafanaIntegrationsArgs =
        com.pulumi.azurenative.dashboard.inputs.GrafanaIntegrationsArgs.builder()
            .azureMonitorWorkspaceIntegrations(
                azureMonitorWorkspaceIntegrations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [GrafanaIntegrationsArgs].
 */
@PulumiTagMarker
public class GrafanaIntegrationsArgsBuilder internal constructor() {
    private var azureMonitorWorkspaceIntegrations: Output<List<AzureMonitorWorkspaceIntegrationArgs>>? =
        null

    /**
     * @param value
     */
    @JvmName("upalelsyogpjdnuw")
    public suspend
    fun azureMonitorWorkspaceIntegrations(`value`: Output<List<AzureMonitorWorkspaceIntegrationArgs>>) {
        this.azureMonitorWorkspaceIntegrations = value
    }

    @JvmName("ebjetwifqduwgxfh")
    public suspend fun azureMonitorWorkspaceIntegrations(
        vararg
        values: Output<AzureMonitorWorkspaceIntegrationArgs>,
    ) {
        this.azureMonitorWorkspaceIntegrations = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ntgstmhelxvcgaac")
    public suspend
    fun azureMonitorWorkspaceIntegrations(values: List<Output<AzureMonitorWorkspaceIntegrationArgs>>) {
        this.azureMonitorWorkspaceIntegrations = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("fltqnbjkpvcagnpj")
    public suspend
    fun azureMonitorWorkspaceIntegrations(`value`: List<AzureMonitorWorkspaceIntegrationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureMonitorWorkspaceIntegrations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lsjdahrklfqgehao")
    public suspend
    fun azureMonitorWorkspaceIntegrations(argument: List<suspend AzureMonitorWorkspaceIntegrationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureMonitorWorkspaceIntegrationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.azureMonitorWorkspaceIntegrations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rbmptvqynvapwtab")
    public suspend fun azureMonitorWorkspaceIntegrations(
        vararg
        argument: suspend AzureMonitorWorkspaceIntegrationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AzureMonitorWorkspaceIntegrationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.azureMonitorWorkspaceIntegrations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rojqhwitofepvynm")
    public suspend
    fun azureMonitorWorkspaceIntegrations(argument: suspend AzureMonitorWorkspaceIntegrationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AzureMonitorWorkspaceIntegrationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.azureMonitorWorkspaceIntegrations = mapped
    }

    /**
     * @param values
     */
    @JvmName("mbcjrmenvlitdypg")
    public suspend fun azureMonitorWorkspaceIntegrations(
        vararg
        values: AzureMonitorWorkspaceIntegrationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureMonitorWorkspaceIntegrations = mapped
    }

    internal fun build(): GrafanaIntegrationsArgs = GrafanaIntegrationsArgs(
        azureMonitorWorkspaceIntegrations = azureMonitorWorkspaceIntegrations,
    )
}
