@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dashboard.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The grafana resource type.
 * @property id ARM id of the grafana resource
 * @property identity The managed identity of the grafana resource.
 * @property location The geo-location where the grafana resource lives
 * @property name Name of the grafana resource.
 * @property properties Properties specific to the grafana resource.
 * @property sku The Sku of the grafana resource.
 * @property systemData The system meta data relating to this grafana resource.
 * @property tags The tags for grafana resource.
 * @property type The type of the grafana resource.
 */
public data class GetGrafanaResult(
    public val id: String,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val properties: ManagedGrafanaPropertiesResponse,
    public val sku: ResourceSkuResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dashboard.outputs.GetGrafanaResult):
            GetGrafanaResult = GetGrafanaResult(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dashboard.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.dashboard.kotlin.outputs.ManagedGrafanaPropertiesResponse.Companion.toKotlin(args0)
            }),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dashboard.kotlin.outputs.ResourceSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.dashboard.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
