@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of the account of data.
 */
public enum class DataAccountType(
    public val javaValue: com.pulumi.azurenative.databox.enums.DataAccountType,
) : ConvertibleToJava<com.pulumi.azurenative.databox.enums.DataAccountType> {
    /**
     * Storage Accounts .
     */
    StorageAccount(com.pulumi.azurenative.databox.enums.DataAccountType.StorageAccount),

    /**
     * Azure Managed disk storage.
     */
    ManagedDisk(com.pulumi.azurenative.databox.enums.DataAccountType.ManagedDisk),
    ;

    override fun toJava(): com.pulumi.azurenative.databox.enums.DataAccountType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.enums.DataAccountType):
            DataAccountType = DataAccountType.values().first { it.javaValue == javaType }
    }
}
