@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.AzureFileFilterDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Filter details to transfer Azure files
 * @property filePathList List of full path of the files to be transferred.
 * @property filePrefixList Prefix list of the Azure files to be transferred.
 * @property fileShareList List of file shares to be transferred.
 */
public data class AzureFileFilterDetailsArgs(
    public val filePathList: Output<List<String>>? = null,
    public val filePrefixList: Output<List<String>>? = null,
    public val fileShareList: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.AzureFileFilterDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.AzureFileFilterDetailsArgs =
        com.pulumi.azurenative.databox.inputs.AzureFileFilterDetailsArgs.builder()
            .filePathList(filePathList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .filePrefixList(filePrefixList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .fileShareList(fileShareList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AzureFileFilterDetailsArgs].
 */
@PulumiTagMarker
public class AzureFileFilterDetailsArgsBuilder internal constructor() {
    private var filePathList: Output<List<String>>? = null

    private var filePrefixList: Output<List<String>>? = null

    private var fileShareList: Output<List<String>>? = null

    /**
     * @param value List of full path of the files to be transferred.
     */
    @JvmName("qkvirgbyvisgmtwe")
    public suspend fun filePathList(`value`: Output<List<String>>) {
        this.filePathList = value
    }

    @JvmName("hpoupflrrsevjteo")
    public suspend fun filePathList(vararg values: Output<String>) {
        this.filePathList = Output.all(values.asList())
    }

    /**
     * @param values List of full path of the files to be transferred.
     */
    @JvmName("juldrhbptgrkmugh")
    public suspend fun filePathList(values: List<Output<String>>) {
        this.filePathList = Output.all(values)
    }

    /**
     * @param value Prefix list of the Azure files to be transferred.
     */
    @JvmName("ecgsqfjwmuspstdk")
    public suspend fun filePrefixList(`value`: Output<List<String>>) {
        this.filePrefixList = value
    }

    @JvmName("waegcplcxmtoyhco")
    public suspend fun filePrefixList(vararg values: Output<String>) {
        this.filePrefixList = Output.all(values.asList())
    }

    /**
     * @param values Prefix list of the Azure files to be transferred.
     */
    @JvmName("ufyxrctrkeqpydqn")
    public suspend fun filePrefixList(values: List<Output<String>>) {
        this.filePrefixList = Output.all(values)
    }

    /**
     * @param value List of file shares to be transferred.
     */
    @JvmName("ncqkdqrxeewtqnfh")
    public suspend fun fileShareList(`value`: Output<List<String>>) {
        this.fileShareList = value
    }

    @JvmName("nudvoaivypsybevk")
    public suspend fun fileShareList(vararg values: Output<String>) {
        this.fileShareList = Output.all(values.asList())
    }

    /**
     * @param values List of file shares to be transferred.
     */
    @JvmName("lqtmpxhgcgqxtmiq")
    public suspend fun fileShareList(values: List<Output<String>>) {
        this.fileShareList = Output.all(values)
    }

    /**
     * @param value List of full path of the files to be transferred.
     */
    @JvmName("xcnnrjqyebbwpilh")
    public suspend fun filePathList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filePathList = mapped
    }

    /**
     * @param values List of full path of the files to be transferred.
     */
    @JvmName("wqfiveiqbeiwwsqy")
    public suspend fun filePathList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filePathList = mapped
    }

    /**
     * @param value Prefix list of the Azure files to be transferred.
     */
    @JvmName("dwvpexddmnulysya")
    public suspend fun filePrefixList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filePrefixList = mapped
    }

    /**
     * @param values Prefix list of the Azure files to be transferred.
     */
    @JvmName("qqlugavydacoxecd")
    public suspend fun filePrefixList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filePrefixList = mapped
    }

    /**
     * @param value List of file shares to be transferred.
     */
    @JvmName("lhnnqpkgcymsurnf")
    public suspend fun fileShareList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileShareList = mapped
    }

    /**
     * @param values List of file shares to be transferred.
     */
    @JvmName("nyvopvfjxafnnqyl")
    public suspend fun fileShareList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileShareList = mapped
    }

    internal fun build(): AzureFileFilterDetailsArgs = AzureFileFilterDetailsArgs(
        filePathList = filePathList,
        filePrefixList = filePrefixList,
        fileShareList = fileShareList,
    )
}
