@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.EncryptionPreferencesArgs.builder
import com.pulumi.azurenative.databox.kotlin.enums.DoubleEncryption
import com.pulumi.azurenative.databox.kotlin.enums.HardwareEncryption
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Preferences related to the Encryption.
 * @property doubleEncryption Defines secondary layer of software-based encryption enablement.
 * @property hardwareEncryption Defines Hardware level encryption (Only for disk)
 */
public data class EncryptionPreferencesArgs(
    public val doubleEncryption: Output<Either<String, DoubleEncryption>>? = null,
    public val hardwareEncryption: Output<Either<String, HardwareEncryption>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.EncryptionPreferencesArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.EncryptionPreferencesArgs =
        com.pulumi.azurenative.databox.inputs.EncryptionPreferencesArgs.builder()
            .doubleEncryption(
                doubleEncryption?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .hardwareEncryption(
                hardwareEncryption?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [EncryptionPreferencesArgs].
 */
@PulumiTagMarker
public class EncryptionPreferencesArgsBuilder internal constructor() {
    private var doubleEncryption: Output<Either<String, DoubleEncryption>>? = null

    private var hardwareEncryption: Output<Either<String, HardwareEncryption>>? = null

    /**
     * @param value Defines secondary layer of software-based encryption enablement.
     */
    @JvmName("mgkseopmurjrrxir")
    public suspend fun doubleEncryption(`value`: Output<Either<String, DoubleEncryption>>) {
        this.doubleEncryption = value
    }

    /**
     * @param value Defines Hardware level encryption (Only for disk)
     */
    @JvmName("tylbdkmxscahgadn")
    public suspend fun hardwareEncryption(`value`: Output<Either<String, HardwareEncryption>>) {
        this.hardwareEncryption = value
    }

    /**
     * @param value Defines secondary layer of software-based encryption enablement.
     */
    @JvmName("jjdskvwfgfctjgkg")
    public suspend fun doubleEncryption(`value`: Either<String, DoubleEncryption>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.doubleEncryption = mapped
    }

    /**
     * @param value Defines secondary layer of software-based encryption enablement.
     */
    @JvmName("gtagsyjvjdbunqxs")
    public fun doubleEncryption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DoubleEncryption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.doubleEncryption = mapped
    }

    /**
     * @param value Defines secondary layer of software-based encryption enablement.
     */
    @JvmName("mobvkuefhsiighbr")
    public fun doubleEncryption(`value`: DoubleEncryption) {
        val toBeMapped = Either.ofRight<String, DoubleEncryption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.doubleEncryption = mapped
    }

    /**
     * @param value Defines Hardware level encryption (Only for disk)
     */
    @JvmName("bnyspcsdfdwywvcl")
    public suspend fun hardwareEncryption(`value`: Either<String, HardwareEncryption>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hardwareEncryption = mapped
    }

    /**
     * @param value Defines Hardware level encryption (Only for disk)
     */
    @JvmName("vhysxpanjmkrixci")
    public fun hardwareEncryption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HardwareEncryption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hardwareEncryption = mapped
    }

    /**
     * @param value Defines Hardware level encryption (Only for disk)
     */
    @JvmName("psckakhyagaiwuij")
    public fun hardwareEncryption(`value`: HardwareEncryption) {
        val toBeMapped = Either.ofRight<String, HardwareEncryption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hardwareEncryption = mapped
    }

    internal fun build(): EncryptionPreferencesArgs = EncryptionPreferencesArgs(
        doubleEncryption = doubleEncryption,
        hardwareEncryption = hardwareEncryption,
    )
}
