@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.GetJobPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand $expand is supported on details parameter for job, which provides details on the job stages.
 * @property jobName The name of the job Resource within the specified resource group. job names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
 * @property resourceGroupName The Resource Group Name
 */
public data class GetJobPlainArgs(
    public val expand: String? = null,
    public val jobName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.GetJobPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.GetJobPlainArgs =
        com.pulumi.azurenative.databox.inputs.GetJobPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .jobName(jobName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetJobPlainArgs].
 */
@PulumiTagMarker
public class GetJobPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var jobName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value $expand is supported on details parameter for job, which provides details on the job stages.
     */
    @JvmName("hpfphyvjliqgveob")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the job Resource within the specified resource group. job names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
     */
    @JvmName("junsfqcviljhsvgn")
    public suspend fun jobName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobName = mapped
    }

    /**
     * @param value The Resource Group Name
     */
    @JvmName("thyyvhmfdaxaajpo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetJobPlainArgs = GetJobPlainArgs(
        expand = expand,
        jobName = jobName ?: throw PulumiNullFieldException("jobName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
