@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.IdentityPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Managed identity properties.
 * @property type Managed service identity type.
 * @property userAssigned User assigned identity properties.
 */
public data class IdentityPropertiesArgs(
    public val type: Output<String>? = null,
    public val userAssigned: Output<UserAssignedPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.IdentityPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.IdentityPropertiesArgs =
        com.pulumi.azurenative.databox.inputs.IdentityPropertiesArgs.builder()
            .type(type?.applyValue({ args0 -> args0 }))
            .userAssigned(userAssigned?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [IdentityPropertiesArgs].
 */
@PulumiTagMarker
public class IdentityPropertiesArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var userAssigned: Output<UserAssignedPropertiesArgs>? = null

    /**
     * @param value Managed service identity type.
     */
    @JvmName("xneevsjejvauaihf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value User assigned identity properties.
     */
    @JvmName("ogkxkhdewtmeyyck")
    public suspend fun userAssigned(`value`: Output<UserAssignedPropertiesArgs>) {
        this.userAssigned = value
    }

    /**
     * @param value Managed service identity type.
     */
    @JvmName("tecwwrdpciyckxos")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value User assigned identity properties.
     */
    @JvmName("tpewbqxibcpifmbm")
    public suspend fun userAssigned(`value`: UserAssignedPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssigned = mapped
    }

    /**
     * @param argument User assigned identity properties.
     */
    @JvmName("wemjylwpollwvvtq")
    public suspend fun userAssigned(argument: suspend UserAssignedPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = UserAssignedPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.userAssigned = mapped
    }

    internal fun build(): IdentityPropertiesArgs = IdentityPropertiesArgs(
        type = type,
        userAssigned = userAssigned,
    )
}
