@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.PreferencesArgs.builder
import com.pulumi.azurenative.databox.kotlin.enums.StorageAccountAccessTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Preferences related to the order
 * @property encryptionPreferences Preferences related to the Encryption.
 * @property preferredDataCenterRegion Preferred data center region.
 * @property reverseTransportPreferences Optional Preferences related to the reverse shipment logistics of the sku.
 * @property storageAccountAccessTierPreferences Preferences related to the Access Tier of storage accounts.
 * @property transportPreferences Preferences related to the shipment logistics of the sku.
 */
public data class PreferencesArgs(
    public val encryptionPreferences: Output<EncryptionPreferencesArgs>? = null,
    public val preferredDataCenterRegion: Output<List<String>>? = null,
    public val reverseTransportPreferences: Output<TransportPreferencesArgs>? = null,
    public val storageAccountAccessTierPreferences:
    Output<List<Either<String, StorageAccountAccessTier>>>? = null,
    public val transportPreferences: Output<TransportPreferencesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.PreferencesArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.PreferencesArgs =
        com.pulumi.azurenative.databox.inputs.PreferencesArgs.builder()
            .encryptionPreferences(
                encryptionPreferences?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .preferredDataCenterRegion(
                preferredDataCenterRegion?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .reverseTransportPreferences(
                reverseTransportPreferences?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .storageAccountAccessTierPreferences(
                storageAccountAccessTierPreferences?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 ->
                                args0.toJava()
                            })
                        })
                    })
                }),
            )
            .transportPreferences(
                transportPreferences?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [PreferencesArgs].
 */
@PulumiTagMarker
public class PreferencesArgsBuilder internal constructor() {
    private var encryptionPreferences: Output<EncryptionPreferencesArgs>? = null

    private var preferredDataCenterRegion: Output<List<String>>? = null

    private var reverseTransportPreferences: Output<TransportPreferencesArgs>? = null

    private var storageAccountAccessTierPreferences:
        Output<List<Either<String, StorageAccountAccessTier>>>? = null

    private var transportPreferences: Output<TransportPreferencesArgs>? = null

    /**
     * @param value Preferences related to the Encryption.
     */
    @JvmName("ldvbxdqaelphhyaa")
    public suspend fun encryptionPreferences(`value`: Output<EncryptionPreferencesArgs>) {
        this.encryptionPreferences = value
    }

    /**
     * @param value Preferred data center region.
     */
    @JvmName("wquktcmmhjbiiatl")
    public suspend fun preferredDataCenterRegion(`value`: Output<List<String>>) {
        this.preferredDataCenterRegion = value
    }

    @JvmName("gjyekjrmvygkmeoi")
    public suspend fun preferredDataCenterRegion(vararg values: Output<String>) {
        this.preferredDataCenterRegion = Output.all(values.asList())
    }

    /**
     * @param values Preferred data center region.
     */
    @JvmName("kqoflfmvmqhglbds")
    public suspend fun preferredDataCenterRegion(values: List<Output<String>>) {
        this.preferredDataCenterRegion = Output.all(values)
    }

    /**
     * @param value Optional Preferences related to the reverse shipment logistics of the sku.
     */
    @JvmName("wkltubtjxrkvlrkl")
    public suspend fun reverseTransportPreferences(`value`: Output<TransportPreferencesArgs>) {
        this.reverseTransportPreferences = value
    }

    /**
     * @param value Preferences related to the Access Tier of storage accounts.
     */
    @JvmName("fdwljayhqhyixybw")
    public suspend
    fun storageAccountAccessTierPreferences(`value`: Output<List<Either<String, StorageAccountAccessTier>>>) {
        this.storageAccountAccessTierPreferences = value
    }

    @JvmName("ukagykjgdvqqslhk")
    public suspend fun storageAccountAccessTierPreferences(
        vararg
        values: Output<Either<String, StorageAccountAccessTier>>,
    ) {
        this.storageAccountAccessTierPreferences = Output.all(values.asList())
    }

    /**
     * @param values Preferences related to the Access Tier of storage accounts.
     */
    @JvmName("ldauieybpqyiruqg")
    public suspend
    fun storageAccountAccessTierPreferences(values: List<Output<Either<String, StorageAccountAccessTier>>>) {
        this.storageAccountAccessTierPreferences = Output.all(values)
    }

    /**
     * @param value Preferences related to the shipment logistics of the sku.
     */
    @JvmName("vnhwxqjnoeybwvyi")
    public suspend fun transportPreferences(`value`: Output<TransportPreferencesArgs>) {
        this.transportPreferences = value
    }

    /**
     * @param value Preferences related to the Encryption.
     */
    @JvmName("jffnhfpndgefodxv")
    public suspend fun encryptionPreferences(`value`: EncryptionPreferencesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionPreferences = mapped
    }

    /**
     * @param argument Preferences related to the Encryption.
     */
    @JvmName("yabmcoloouxkslvu")
    public suspend
    fun encryptionPreferences(argument: suspend EncryptionPreferencesArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionPreferencesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionPreferences = mapped
    }

    /**
     * @param value Preferred data center region.
     */
    @JvmName("eifjpxxudvnreiie")
    public suspend fun preferredDataCenterRegion(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredDataCenterRegion = mapped
    }

    /**
     * @param values Preferred data center region.
     */
    @JvmName("tbbhbpmvfdkvbeex")
    public suspend fun preferredDataCenterRegion(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferredDataCenterRegion = mapped
    }

    /**
     * @param value Optional Preferences related to the reverse shipment logistics of the sku.
     */
    @JvmName("vocnxueeuaaaxthk")
    public suspend fun reverseTransportPreferences(`value`: TransportPreferencesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reverseTransportPreferences = mapped
    }

    /**
     * @param argument Optional Preferences related to the reverse shipment logistics of the sku.
     */
    @JvmName("mxltipnovtacfkeq")
    public suspend
    fun reverseTransportPreferences(argument: suspend TransportPreferencesArgsBuilder.() -> Unit) {
        val toBeMapped = TransportPreferencesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.reverseTransportPreferences = mapped
    }

    /**
     * @param value Preferences related to the Access Tier of storage accounts.
     */
    @JvmName("eglpwitnrqorugxe")
    public suspend
    fun storageAccountAccessTierPreferences(`value`: List<Either<String, StorageAccountAccessTier>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountAccessTierPreferences = mapped
    }

    /**
     * @param values Preferences related to the Access Tier of storage accounts.
     */
    @JvmName("qewtdoqmafnhdesw")
    public suspend fun storageAccountAccessTierPreferences(
        vararg
        values: Either<String, StorageAccountAccessTier>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountAccessTierPreferences = mapped
    }

    /**
     * @param value Preferences related to the shipment logistics of the sku.
     */
    @JvmName("qhaxsgefyntodolq")
    public suspend fun transportPreferences(`value`: TransportPreferencesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transportPreferences = mapped
    }

    /**
     * @param argument Preferences related to the shipment logistics of the sku.
     */
    @JvmName("glvlgeqacagtxrjy")
    public suspend
    fun transportPreferences(argument: suspend TransportPreferencesArgsBuilder.() -> Unit) {
        val toBeMapped = TransportPreferencesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.transportPreferences = mapped
    }

    internal fun build(): PreferencesArgs = PreferencesArgs(
        encryptionPreferences = encryptionPreferences,
        preferredDataCenterRegion = preferredDataCenterRegion,
        reverseTransportPreferences = reverseTransportPreferences,
        storageAccountAccessTierPreferences = storageAccountAccessTierPreferences,
        transportPreferences = transportPreferences,
    )
}
