@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.ReverseShippingDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Reverse Shipping Address and contact details for a job.
 * @property contactDetails Contact Info.
 * @property shippingAddress Shipping address where customer wishes to receive the device.
 */
public data class ReverseShippingDetailsArgs(
    public val contactDetails: Output<ContactInfoArgs>? = null,
    public val shippingAddress: Output<ShippingAddressArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.ReverseShippingDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.ReverseShippingDetailsArgs =
        com.pulumi.azurenative.databox.inputs.ReverseShippingDetailsArgs.builder()
            .contactDetails(contactDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .shippingAddress(
                shippingAddress?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ReverseShippingDetailsArgs].
 */
@PulumiTagMarker
public class ReverseShippingDetailsArgsBuilder internal constructor() {
    private var contactDetails: Output<ContactInfoArgs>? = null

    private var shippingAddress: Output<ShippingAddressArgs>? = null

    /**
     * @param value Contact Info.
     */
    @JvmName("syuursucchkixisw")
    public suspend fun contactDetails(`value`: Output<ContactInfoArgs>) {
        this.contactDetails = value
    }

    /**
     * @param value Shipping address where customer wishes to receive the device.
     */
    @JvmName("htffncjnfsixvpxr")
    public suspend fun shippingAddress(`value`: Output<ShippingAddressArgs>) {
        this.shippingAddress = value
    }

    /**
     * @param value Contact Info.
     */
    @JvmName("dguvkjoodqtkchbc")
    public suspend fun contactDetails(`value`: ContactInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactDetails = mapped
    }

    /**
     * @param argument Contact Info.
     */
    @JvmName("bhfamdqiukxvkfcu")
    public suspend fun contactDetails(argument: suspend ContactInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ContactInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contactDetails = mapped
    }

    /**
     * @param value Shipping address where customer wishes to receive the device.
     */
    @JvmName("jcyfphsdjobevhlf")
    public suspend fun shippingAddress(`value`: ShippingAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shippingAddress = mapped
    }

    /**
     * @param argument Shipping address where customer wishes to receive the device.
     */
    @JvmName("klhtpwlxtadgffpw")
    public suspend fun shippingAddress(argument: suspend ShippingAddressArgsBuilder.() -> Unit) {
        val toBeMapped = ShippingAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.shippingAddress = mapped
    }

    internal fun build(): ReverseShippingDetailsArgs = ReverseShippingDetailsArgs(
        contactDetails = contactDetails,
        shippingAddress = shippingAddress,
    )
}
