@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.SkuArgs.builder
import com.pulumi.azurenative.databox.kotlin.enums.SkuName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Sku.
 * @property displayName The display name of the sku.
 * @property family The sku family.
 * @property name The sku name.
 */
public data class SkuArgs(
    public val displayName: Output<String>? = null,
    public val family: Output<String>? = null,
    public val name: Output<Either<String, SkuName>>,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.SkuArgs =
        com.pulumi.azurenative.databox.inputs.SkuArgs.builder()
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var displayName: Output<String>? = null

    private var family: Output<String>? = null

    private var name: Output<Either<String, SkuName>>? = null

    /**
     * @param value The display name of the sku.
     */
    @JvmName("bcmrbbvwbysectit")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The sku family.
     */
    @JvmName("hgveystctghvavlj")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value The sku name.
     */
    @JvmName("xycmdpguykpswfsy")
    public suspend fun name(`value`: Output<Either<String, SkuName>>) {
        this.name = value
    }

    /**
     * @param value The display name of the sku.
     */
    @JvmName("ethxfqxeunssdeip")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The sku family.
     */
    @JvmName("ydfwbuualpacmfdp")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value The sku name.
     */
    @JvmName("ftlutxbcijihmunh")
    public suspend fun name(`value`: Either<String, SkuName>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The sku name.
     */
    @JvmName("ahmjstumwgkulhuw")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The sku name.
     */
    @JvmName("gjidankcdhvuensb")
    public fun name(`value`: SkuName) {
        val toBeMapped = Either.ofRight<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        displayName = displayName,
        family = family,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
