@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.TransferConfigurationTransferFilterDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Map of filter type and the details to filter. This field is required only if the TransferConfigurationType is given as TransferUsingFilter.
 * @property include Details of the filtering the transfer of data.
 */
public data class TransferConfigurationTransferFilterDetailsArgs(
    public val include: Output<TransferFilterDetailsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.databox.inputs.TransferConfigurationTransferFilterDetailsArgs> {
    override fun toJava():
        com.pulumi.azurenative.databox.inputs.TransferConfigurationTransferFilterDetailsArgs =
        com.pulumi.azurenative.databox.inputs.TransferConfigurationTransferFilterDetailsArgs.builder()
            .include(include?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [TransferConfigurationTransferFilterDetailsArgs].
 */
@PulumiTagMarker
public class TransferConfigurationTransferFilterDetailsArgsBuilder internal constructor() {
    private var include: Output<TransferFilterDetailsArgs>? = null

    /**
     * @param value Details of the filtering the transfer of data.
     */
    @JvmName("kkcdlidrewbayayu")
    public suspend fun include(`value`: Output<TransferFilterDetailsArgs>) {
        this.include = value
    }

    /**
     * @param value Details of the filtering the transfer of data.
     */
    @JvmName("vctgbiufxlksdmwj")
    public suspend fun include(`value`: TransferFilterDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.include = mapped
    }

    /**
     * @param argument Details of the filtering the transfer of data.
     */
    @JvmName("bmqridoibygqpstl")
    public suspend fun include(argument: suspend TransferFilterDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = TransferFilterDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.include = mapped
    }

    internal fun build(): TransferConfigurationTransferFilterDetailsArgs =
        TransferConfigurationTransferFilterDetailsArgs(
            include = include,
        )
}
