@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.TransportPreferencesArgs.builder
import com.pulumi.azurenative.databox.kotlin.enums.TransportShipmentTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Preferences related to the shipment logistics of the sku
 * @property preferredShipmentType Indicates Shipment Logistics type that the customer preferred.
 */
public data class TransportPreferencesArgs(
    public val preferredShipmentType: Output<Either<String, TransportShipmentTypes>>,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.TransportPreferencesArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.TransportPreferencesArgs =
        com.pulumi.azurenative.databox.inputs.TransportPreferencesArgs.builder()
            .preferredShipmentType(
                preferredShipmentType.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [TransportPreferencesArgs].
 */
@PulumiTagMarker
public class TransportPreferencesArgsBuilder internal constructor() {
    private var preferredShipmentType: Output<Either<String, TransportShipmentTypes>>? = null

    /**
     * @param value Indicates Shipment Logistics type that the customer preferred.
     */
    @JvmName("gfecmypipgxksbsp")
    public suspend
    fun preferredShipmentType(`value`: Output<Either<String, TransportShipmentTypes>>) {
        this.preferredShipmentType = value
    }

    /**
     * @param value Indicates Shipment Logistics type that the customer preferred.
     */
    @JvmName("iiobaqnuuwjbirle")
    public suspend fun preferredShipmentType(`value`: Either<String, TransportShipmentTypes>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferredShipmentType = mapped
    }

    /**
     * @param value Indicates Shipment Logistics type that the customer preferred.
     */
    @JvmName("pbokegdkrwdlckag")
    public fun preferredShipmentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TransportShipmentTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferredShipmentType = mapped
    }

    /**
     * @param value Indicates Shipment Logistics type that the customer preferred.
     */
    @JvmName("rqyohkfoagougrca")
    public fun preferredShipmentType(`value`: TransportShipmentTypes) {
        val toBeMapped = Either.ofRight<String, TransportShipmentTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferredShipmentType = mapped
    }

    internal fun build(): TransportPreferencesArgs = TransportPreferencesArgs(
        preferredShipmentType = preferredShipmentType ?: throw
            PulumiNullFieldException("preferredShipmentType"),
    )
}
