@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contact Info.
 * @property contactName Contact name of the person.
 * @property mobile Mobile number of the contact person.
 * @property phone Phone number of the contact person.
 * @property phoneExtension Phone extension number of the contact person.
 */
public data class ContactInfoResponse(
    public val contactName: String,
    public val mobile: String? = null,
    public val phone: String,
    public val phoneExtension: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.ContactInfoResponse):
            ContactInfoResponse = ContactInfoResponse(
            contactName = javaType.contactName(),
            mobile = javaType.mobile().map({ args0 -> args0 }).orElse(null),
            phone = javaType.phone(),
            phoneExtension = javaType.phoneExtension().map({ args0 -> args0 }).orElse(null),
        )
    }
}
