@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Copy Log Details for customer disk
 * @property copyLogDetailsType Indicates the type of job details.
 * Expected value is 'DataBoxCustomerDisk'.
 * @property errorLogLink Link for copy error logs.
 * @property serialNumber Disk Serial Number.
 * @property verboseLogLink Link for copy verbose logs.
 */
public data class DataBoxCustomerDiskCopyLogDetailsResponse(
    public val copyLogDetailsType: String,
    public val errorLogLink: String,
    public val serialNumber: String,
    public val verboseLogLink: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.DataBoxCustomerDiskCopyLogDetailsResponse):
            DataBoxCustomerDiskCopyLogDetailsResponse = DataBoxCustomerDiskCopyLogDetailsResponse(
            copyLogDetailsType = javaType.copyLogDetailsType(),
            errorLogLink = javaType.errorLogLink(),
            serialNumber = javaType.serialNumber(),
            verboseLogLink = javaType.verboseLogLink(),
        )
    }
}
