@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * DataBox Disk Copy Progress
 * @property actions Available actions on the job.
 * @property bytesCopied Bytes copied during the copy of disk.
 * @property error Error, if any, in the stage
 * @property percentComplete Indicates the percentage completed for the copy of the disk.
 * @property serialNumber The serial number of the disk
 * @property status The Status of the copy
 */
public data class DataBoxDiskCopyProgressResponse(
    public val actions: List<String>,
    public val bytesCopied: Double,
    public val error: CloudErrorResponse,
    public val percentComplete: Int,
    public val serialNumber: String,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.DataBoxDiskCopyProgressResponse):
            DataBoxDiskCopyProgressResponse = DataBoxDiskCopyProgressResponse(
            actions = javaType.actions().map({ args0 -> args0 }),
            bytesCopied = javaType.bytesCopied(),
            error = javaType.error().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.CloudErrorResponse.Companion.toKotlin(args0)
            }),
            percentComplete = javaType.percentComplete(),
            serialNumber = javaType.serialNumber(),
            status = javaType.status(),
        )
    }
}
