@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Copy log details for a storage account for Databox heavy
 * @property accountName Account name.
 * @property copyLogDetailsType Indicates the type of job details.
 * Expected value is 'DataBoxHeavy'.
 * @property copyLogLink Link for copy logs.
 * @property copyVerboseLogLink Link for copy verbose logs. This will be set only when the LogCollectionLevel is set to verbose.
 */
public data class DataBoxHeavyAccountCopyLogDetailsResponse(
    public val accountName: String,
    public val copyLogDetailsType: String,
    public val copyLogLink: List<String>,
    public val copyVerboseLogLink: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.DataBoxHeavyAccountCopyLogDetailsResponse):
            DataBoxHeavyAccountCopyLogDetailsResponse = DataBoxHeavyAccountCopyLogDetailsResponse(
            accountName = javaType.accountName(),
            copyLogDetailsType = javaType.copyLogDetailsType(),
            copyLogLink = javaType.copyLogLink().map({ args0 -> args0 }),
            copyVerboseLogLink = javaType.copyVerboseLogLink().map({ args0 -> args0 }),
        )
    }
}
