@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Dc access security code
 * @property forwardDCAccessCode Forward Dc access security code.
 * @property reverseDCAccessCode Reverse Dc access security code.
 */
public data class DcAccessSecurityCodeResponse(
    public val forwardDCAccessCode: String? = null,
    public val reverseDCAccessCode: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.DcAccessSecurityCodeResponse):
            DcAccessSecurityCodeResponse = DcAccessSecurityCodeResponse(
            forwardDCAccessCode = javaType.forwardDCAccessCode().map({ args0 -> args0 }).orElse(null),
            reverseDCAccessCode = javaType.reverseDCAccessCode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
