@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Job Resource.
 * @property cancellationReason Reason for cancellation.
 * @property deliveryInfo Delivery Info of Job.
 * @property deliveryType Delivery type of Job.
 * @property details Details of a job run. This field will only be sent for expand details filter.
 * @property error Top level error for the job.
 * @property id Id of the object.
 * @property identity Msi identity of the resource
 * @property isCancellable Describes whether the job is cancellable or not.
 * @property isCancellableWithoutFee Flag to indicate cancellation of scheduled job.
 * @property isDeletable Describes whether the job is deletable or not.
 * @property isPrepareToShipEnabled Is Prepare To Ship Enabled on this job
 * @property isShippingAddressEditable Describes whether the shipping address is editable or not.
 * @property location The location of the resource. This will be one of the supported and registered Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a resource cannot be changed once it is created, but if an identical region is specified on update the request will succeed.
 * @property name Name of the object.
 * @property reverseShippingDetailsUpdate The Editable status for Reverse Shipping Address and Contact Info
 * @property reverseTransportPreferenceUpdate The Editable status for Reverse Transport preferences
 * @property sku The sku type.
 * @property startTime Time at which the job was started in UTC ISO 8601 format.
 * @property status Name of the stage which is in progress.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups).
 * @property transferType Type of the data transfer.
 * @property type Type of the object.
 */
public data class GetJobResult(
    public val cancellationReason: String,
    public val deliveryInfo: JobDeliveryInfoResponse? = null,
    public val deliveryType: String? = null,
    public val details: Any? = null,
    public val error: CloudErrorResponse,
    public val id: String,
    public val identity: ResourceIdentityResponse? = null,
    public val isCancellable: Boolean,
    public val isCancellableWithoutFee: Boolean,
    public val isDeletable: Boolean,
    public val isPrepareToShipEnabled: Boolean,
    public val isShippingAddressEditable: Boolean,
    public val location: String,
    public val name: String,
    public val reverseShippingDetailsUpdate: String,
    public val reverseTransportPreferenceUpdate: String,
    public val sku: SkuResponse,
    public val startTime: String,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val transferType: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.GetJobResult): GetJobResult =
            GetJobResult(
                cancellationReason = javaType.cancellationReason(),
                deliveryInfo = javaType.deliveryInfo().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.databox.kotlin.outputs.JobDeliveryInfoResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                deliveryType = javaType.deliveryType().map({ args0 -> args0 }).orElse(null),
                details = javaType.details().map({ args0 -> args0 }).orElse(null),
                error = javaType.error().let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.CloudErrorResponse.Companion.toKotlin(args0)
                }),
                id = javaType.id(),
                identity = javaType.identity().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.databox.kotlin.outputs.ResourceIdentityResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                isCancellable = javaType.isCancellable(),
                isCancellableWithoutFee = javaType.isCancellableWithoutFee(),
                isDeletable = javaType.isDeletable(),
                isPrepareToShipEnabled = javaType.isPrepareToShipEnabled(),
                isShippingAddressEditable = javaType.isShippingAddressEditable(),
                location = javaType.location(),
                name = javaType.name(),
                reverseShippingDetailsUpdate = javaType.reverseShippingDetailsUpdate(),
                reverseTransportPreferenceUpdate = javaType.reverseTransportPreferenceUpdate(),
                sku = javaType.sku().let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                }),
                startTime = javaType.startTime(),
                status = javaType.status(),
                systemData = javaType.systemData().let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                }),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                transferType = javaType.transferType(),
                type = javaType.type(),
            )
    }
}
