@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Encryption key containing details about key to encrypt different keys.
 * @property identityProperties Managed identity properties used for key encryption.
 * @property kekType Type of encryption key used for key encryption.
 * @property kekUrl Key encryption key. It is required in case of Customer managed KekType.
 * @property kekVaultResourceID Kek vault resource id. It is required in case of Customer managed KekType.
 */
public data class KeyEncryptionKeyResponse(
    public val identityProperties: IdentityPropertiesResponse? = null,
    public val kekType: String,
    public val kekUrl: String? = null,
    public val kekVaultResourceID: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.KeyEncryptionKeyResponse):
            KeyEncryptionKeyResponse = KeyEncryptionKeyResponse(
            identityProperties = javaType.identityProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.IdentityPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kekType = javaType.kekType(),
            kekUrl = javaType.kekUrl().map({ args0 -> args0 }).orElse(null),
            kekVaultResourceID = javaType.kekVaultResourceID().map({ args0 -> args0 }).orElse(null),
        )
    }
}
