@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Reverse Shipping Address and contact details for a job.
 * @property contactDetails Contact Info.
 * @property isUpdated A flag to indicate whether Reverse Shipping details are updated or not after device has been prepared.
 * Read only field
 * @property shippingAddress Shipping address where customer wishes to receive the device.
 */
public data class ReverseShippingDetailsResponse(
    public val contactDetails: ContactInfoResponse? = null,
    public val isUpdated: Boolean,
    public val shippingAddress: ShippingAddressResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.ReverseShippingDetailsResponse):
            ReverseShippingDetailsResponse = ReverseShippingDetailsResponse(
            contactDetails = javaType.contactDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.ContactInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            isUpdated = javaType.isUpdated(),
            shippingAddress = javaType.shippingAddress().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.ShippingAddressResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
