@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Sku.
 * @property displayName The display name of the sku.
 * @property family The sku family.
 * @property name The sku name.
 */
public data class SkuResponse(
    public val displayName: String? = null,
    public val family: String? = null,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.SkuResponse): SkuResponse =
            SkuResponse(
                displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
                family = javaType.family().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
            )
    }
}
