@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Details to transfer all data.
 * @property dataAccountType Type of the account of data
 * @property transferAllBlobs To indicate if all Azure blobs have to be transferred
 * @property transferAllFiles To indicate if all Azure Files have to be transferred
 */
public data class TransferAllDetailsResponse(
    public val dataAccountType: String,
    public val transferAllBlobs: Boolean? = null,
    public val transferAllFiles: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.TransferAllDetailsResponse):
            TransferAllDetailsResponse = TransferAllDetailsResponse(
            dataAccountType = javaType.dataAccountType(),
            transferAllBlobs = javaType.transferAllBlobs().map({ args0 -> args0 }).orElse(null),
            transferAllFiles = javaType.transferAllFiles().map({ args0 -> args0 }).orElse(null),
        )
    }
}
