@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Preferences related to the shipment logistics of the sku
 * @property isUpdated Read only property which indicates whether transport preferences has been updated or not after device is prepared.
 * @property preferredShipmentType Indicates Shipment Logistics type that the customer preferred.
 */
public data class TransportPreferencesResponse(
    public val isUpdated: Boolean,
    public val preferredShipmentType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.TransportPreferencesResponse):
            TransportPreferencesResponse = TransportPreferencesResponse(
            isUpdated = javaType.isUpdated(),
            preferredShipmentType = javaType.preferredShipmentType(),
        )
    }
}
