@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * User assigned identity properties.
 * @property resourceId Arm resource id for user assigned identity to be used to fetch MSI token.
 */
public data class UserAssignedPropertiesResponse(
    public val resourceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.UserAssignedPropertiesResponse):
            UserAssignedPropertiesResponse = UserAssignedPropertiesResponse(
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
