@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [BandwidthSchedule].
 */
@PulumiTagMarker
public class BandwidthScheduleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BandwidthScheduleArgs = BandwidthScheduleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BandwidthScheduleArgsBuilder.() -> Unit) {
        val builder = BandwidthScheduleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BandwidthSchedule {
        val builtJavaResource =
            com.pulumi.azurenative.databoxedge.BandwidthSchedule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BandwidthSchedule(builtJavaResource)
    }
}

/**
 * The bandwidth schedule details.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-01-01-preview, 2023-07-01, 2023-12-01.
 * ## Example Usage
 * ### BandwidthSchedulePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bandwidthSchedule = new AzureNative.DataBoxEdge.BandwidthSchedule("bandwidthSchedule", new()
 *     {
 *         Days = new[]
 *         {
 *             "Sunday",
 *             "Monday",
 *         },
 *         DeviceName = "testedgedevice",
 *         Name = "bandwidth-1",
 *         RateInMbps = 100,
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         Start = "0:0:0",
 *         Stop = "13:59:0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewBandwidthSchedule(ctx, "bandwidthSchedule", &databoxedge.BandwidthScheduleArgs{
 * 			Days: pulumi.StringArray{
 * 				pulumi.String("Sunday"),
 * 				pulumi.String("Monday"),
 * 			},
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			Name:              pulumi.String("bandwidth-1"),
 * 			RateInMbps:        pulumi.Int(100),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			Start:             pulumi.String("0:0:0"),
 * 			Stop:              pulumi.String("13:59:0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.BandwidthSchedule;
 * import com.pulumi.azurenative.databoxedge.BandwidthScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bandwidthSchedule = new BandwidthSchedule("bandwidthSchedule", BandwidthScheduleArgs.builder()
 *             .days(
 *                 "Sunday",
 *                 "Monday")
 *             .deviceName("testedgedevice")
 *             .name("bandwidth-1")
 *             .rateInMbps(100)
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .start("0:0:0")
 *             .stop("13:59:0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:BandwidthSchedule bandwidth-1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/bandwidthSchedules/{name}
 * ```
 */
public class BandwidthSchedule internal constructor(
    override val javaResource: com.pulumi.azurenative.databoxedge.BandwidthSchedule,
) : KotlinCustomResource(javaResource, BandwidthScheduleMapper) {
    /**
     * The days of the week when this schedule is applicable.
     */
    public val days: Output<List<String>>
        get() = javaResource.days().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The object name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The bandwidth rate in Mbps.
     */
    public val rateInMbps: Output<Int>
        get() = javaResource.rateInMbps().applyValue({ args0 -> args0 })

    /**
     * The start time of the schedule in UTC.
     */
    public val start: Output<String>
        get() = javaResource.start().applyValue({ args0 -> args0 })

    /**
     * The stop time of the schedule in UTC.
     */
    public val stop: Output<String>
        get() = javaResource.stop().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of BandwidthSchedule
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BandwidthScheduleMapper : ResourceMapper<BandwidthSchedule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databoxedge.BandwidthSchedule::class == javaResource::class

    override fun map(javaResource: Resource): BandwidthSchedule = BandwidthSchedule(
        javaResource as
            com.pulumi.azurenative.databoxedge.BandwidthSchedule,
    )
}

/**
 * @see [BandwidthSchedule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BandwidthSchedule].
 */
public suspend fun bandwidthSchedule(
    name: String,
    block: suspend BandwidthScheduleResourceBuilder.() -> Unit,
): BandwidthSchedule {
    val builder = BandwidthScheduleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BandwidthSchedule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bandwidthSchedule(name: String): BandwidthSchedule {
    val builder = BandwidthScheduleResourceBuilder()
    builder.name(name)
    return builder.build()
}
