@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.BandwidthScheduleArgs.builder
import com.pulumi.azurenative.databoxedge.kotlin.enums.DayOfWeek
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The bandwidth schedule details.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-01-01-preview, 2023-07-01, 2023-12-01.
 * ## Example Usage
 * ### BandwidthSchedulePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bandwidthSchedule = new AzureNative.DataBoxEdge.BandwidthSchedule("bandwidthSchedule", new()
 *     {
 *         Days = new[]
 *         {
 *             "Sunday",
 *             "Monday",
 *         },
 *         DeviceName = "testedgedevice",
 *         Name = "bandwidth-1",
 *         RateInMbps = 100,
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         Start = "0:0:0",
 *         Stop = "13:59:0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewBandwidthSchedule(ctx, "bandwidthSchedule", &databoxedge.BandwidthScheduleArgs{
 * 			Days: pulumi.StringArray{
 * 				pulumi.String("Sunday"),
 * 				pulumi.String("Monday"),
 * 			},
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			Name:              pulumi.String("bandwidth-1"),
 * 			RateInMbps:        pulumi.Int(100),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			Start:             pulumi.String("0:0:0"),
 * 			Stop:              pulumi.String("13:59:0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.BandwidthSchedule;
 * import com.pulumi.azurenative.databoxedge.BandwidthScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bandwidthSchedule = new BandwidthSchedule("bandwidthSchedule", BandwidthScheduleArgs.builder()
 *             .days(
 *                 "Sunday",
 *                 "Monday")
 *             .deviceName("testedgedevice")
 *             .name("bandwidth-1")
 *             .rateInMbps(100)
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .start("0:0:0")
 *             .stop("13:59:0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:BandwidthSchedule bandwidth-1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/bandwidthSchedules/{name}
 * ```
 * @property days The days of the week when this schedule is applicable.
 * @property deviceName The device name.
 * @property name The bandwidth schedule name which needs to be added/updated.
 * @property rateInMbps The bandwidth rate in Mbps.
 * @property resourceGroupName The resource group name.
 * @property start The start time of the schedule in UTC.
 * @property stop The stop time of the schedule in UTC.
 */
public data class BandwidthScheduleArgs(
    public val days: Output<List<Either<String, DayOfWeek>>>? = null,
    public val deviceName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val rateInMbps: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val start: Output<String>? = null,
    public val stop: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.BandwidthScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.BandwidthScheduleArgs =
        com.pulumi.azurenative.databoxedge.BandwidthScheduleArgs.builder()
            .days(
                days?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        })
                    })
                }),
            )
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .rateInMbps(rateInMbps?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .start(start?.applyValue({ args0 -> args0 }))
            .stop(stop?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BandwidthScheduleArgs].
 */
@PulumiTagMarker
public class BandwidthScheduleArgsBuilder internal constructor() {
    private var days: Output<List<Either<String, DayOfWeek>>>? = null

    private var deviceName: Output<String>? = null

    private var name: Output<String>? = null

    private var rateInMbps: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var start: Output<String>? = null

    private var stop: Output<String>? = null

    /**
     * @param value The days of the week when this schedule is applicable.
     */
    @JvmName("aswooobopxqjmsyj")
    public suspend fun days(`value`: Output<List<Either<String, DayOfWeek>>>) {
        this.days = value
    }

    @JvmName("eenvvgomrtslrawc")
    public suspend fun days(vararg values: Output<Either<String, DayOfWeek>>) {
        this.days = Output.all(values.asList())
    }

    /**
     * @param values The days of the week when this schedule is applicable.
     */
    @JvmName("ccnjmrpbppcsjrqj")
    public suspend fun days(values: List<Output<Either<String, DayOfWeek>>>) {
        this.days = Output.all(values)
    }

    /**
     * @param value The device name.
     */
    @JvmName("unydqbhqynfocogs")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value The bandwidth schedule name which needs to be added/updated.
     */
    @JvmName("xccrhahgicshtylg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The bandwidth rate in Mbps.
     */
    @JvmName("rhshwoidbnprlgyr")
    public suspend fun rateInMbps(`value`: Output<Int>) {
        this.rateInMbps = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("ocukctaluprbaeuo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The start time of the schedule in UTC.
     */
    @JvmName("nqthyovpnivonfax")
    public suspend fun start(`value`: Output<String>) {
        this.start = value
    }

    /**
     * @param value The stop time of the schedule in UTC.
     */
    @JvmName("fybutexiwyabxouk")
    public suspend fun stop(`value`: Output<String>) {
        this.stop = value
    }

    /**
     * @param value The days of the week when this schedule is applicable.
     */
    @JvmName("iqnmieabqcyiqupc")
    public suspend fun days(`value`: List<Either<String, DayOfWeek>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param values The days of the week when this schedule is applicable.
     */
    @JvmName("lctpawxapcescplk")
    public suspend fun days(vararg values: Either<String, DayOfWeek>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param value The device name.
     */
    @JvmName("dfonafmntrpvqwao")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value The bandwidth schedule name which needs to be added/updated.
     */
    @JvmName("ukyobicxegiawcdk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The bandwidth rate in Mbps.
     */
    @JvmName("hrmtsfaktuifcxws")
    public suspend fun rateInMbps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rateInMbps = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("ovwcilldyefqqers")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The start time of the schedule in UTC.
     */
    @JvmName("mrkhadnwmwhrudpa")
    public suspend fun start(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.start = mapped
    }

    /**
     * @param value The stop time of the schedule in UTC.
     */
    @JvmName("woiqxgfycruewnjc")
    public suspend fun stop(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stop = mapped
    }

    internal fun build(): BandwidthScheduleArgs = BandwidthScheduleArgs(
        days = days,
        deviceName = deviceName,
        name = name,
        rateInMbps = rateInMbps,
        resourceGroupName = resourceGroupName,
        start = start,
        stop = stop,
    )
}
