@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.DataboxedgeFunctions.getArcAddonPlain
import com.pulumi.azurenative.databoxedge.DataboxedgeFunctions.getBandwidthSchedulePlain
import com.pulumi.azurenative.databoxedge.DataboxedgeFunctions.getCloudEdgeManagementRolePlain
import com.pulumi.azurenative.databoxedge.DataboxedgeFunctions.getContainerPlain
import com.pulumi.azurenative.databoxedge.DataboxedgeFunctions.getDeviceExtendedInformationPlain
import com.pulumi.azurenative.databoxedge.DataboxedgeFunctions.getDevicePlain
import com.pulumi.azurenative.databoxedge.DataboxedgeFunctions.getFileEventTriggerPlain
import com.pulumi.azurenative.databoxedge.DataboxedgeFunctions.getIoTAddonPlain
import com.pulumi.azurenative.databoxedge.DataboxedgeFunctions.getIoTRolePlain
import com.pulumi.azurenative.databoxedge.DataboxedgeFunctions.getKubernetesRolePlain
import com.pulumi.azurenative.databoxedge.DataboxedgeFunctions.getMECRolePlain
import com.pulumi.azurenative.databoxedge.DataboxedgeFunctions.getMonitoringConfigPlain
import com.pulumi.azurenative.databoxedge.DataboxedgeFunctions.getOrderPlain
import com.pulumi.azurenative.databoxedge.DataboxedgeFunctions.getPeriodicTimerEventTriggerPlain
import com.pulumi.azurenative.databoxedge.DataboxedgeFunctions.getSharePlain
import com.pulumi.azurenative.databoxedge.DataboxedgeFunctions.getStorageAccountCredentialPlain
import com.pulumi.azurenative.databoxedge.DataboxedgeFunctions.getStorageAccountPlain
import com.pulumi.azurenative.databoxedge.DataboxedgeFunctions.getUserPlain
import com.pulumi.azurenative.databoxedge.DataboxedgeFunctions.listOrderDCAccessCodePlain
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetArcAddonPlainArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetArcAddonPlainArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetBandwidthSchedulePlainArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetBandwidthSchedulePlainArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetCloudEdgeManagementRolePlainArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetCloudEdgeManagementRolePlainArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetContainerPlainArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetContainerPlainArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetDeviceExtendedInformationPlainArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetDeviceExtendedInformationPlainArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetDevicePlainArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetDevicePlainArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetFileEventTriggerPlainArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetFileEventTriggerPlainArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetIoTAddonPlainArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetIoTAddonPlainArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetIoTRolePlainArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetIoTRolePlainArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetKubernetesRolePlainArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetKubernetesRolePlainArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetMECRolePlainArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetMECRolePlainArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetMonitoringConfigPlainArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetMonitoringConfigPlainArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetOrderPlainArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetOrderPlainArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetPeriodicTimerEventTriggerPlainArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetPeriodicTimerEventTriggerPlainArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetSharePlainArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetSharePlainArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetStorageAccountCredentialPlainArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetStorageAccountCredentialPlainArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetStorageAccountPlainArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetStorageAccountPlainArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetUserPlainArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.GetUserPlainArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.ListOrderDCAccessCodePlainArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.ListOrderDCAccessCodePlainArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetArcAddonResult
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetBandwidthScheduleResult
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetCloudEdgeManagementRoleResult
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetContainerResult
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetDeviceExtendedInformationResult
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetDeviceResult
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetFileEventTriggerResult
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetIoTAddonResult
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetIoTRoleResult
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetKubernetesRoleResult
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetMECRoleResult
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetMonitoringConfigResult
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetOrderResult
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetPeriodicTimerEventTriggerResult
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetShareResult
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetStorageAccountCredentialResult
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetStorageAccountResult
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetUserResult
import com.pulumi.azurenative.databoxedge.kotlin.outputs.ListOrderDCAccessCodeResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetArcAddonResult.Companion.toKotlin as getArcAddonResultToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetBandwidthScheduleResult.Companion.toKotlin as getBandwidthScheduleResultToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetCloudEdgeManagementRoleResult.Companion.toKotlin as getCloudEdgeManagementRoleResultToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetContainerResult.Companion.toKotlin as getContainerResultToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetDeviceExtendedInformationResult.Companion.toKotlin as getDeviceExtendedInformationResultToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetDeviceResult.Companion.toKotlin as getDeviceResultToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetFileEventTriggerResult.Companion.toKotlin as getFileEventTriggerResultToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetIoTAddonResult.Companion.toKotlin as getIoTAddonResultToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetIoTRoleResult.Companion.toKotlin as getIoTRoleResultToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetKubernetesRoleResult.Companion.toKotlin as getKubernetesRoleResultToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetMECRoleResult.Companion.toKotlin as getMECRoleResultToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetMonitoringConfigResult.Companion.toKotlin as getMonitoringConfigResultToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetOrderResult.Companion.toKotlin as getOrderResultToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetPeriodicTimerEventTriggerResult.Companion.toKotlin as getPeriodicTimerEventTriggerResultToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetShareResult.Companion.toKotlin as getShareResultToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetStorageAccountCredentialResult.Companion.toKotlin as getStorageAccountCredentialResultToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetStorageAccountResult.Companion.toKotlin as getStorageAccountResultToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.GetUserResult.Companion.toKotlin as getUserResultToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.ListOrderDCAccessCodeResult.Companion.toKotlin as listOrderDCAccessCodeResultToKotlin

public object DataboxedgeFunctions {
    /**
     * Gets a specific addon by name.
     * Azure REST API version: 2022-03-01.
     * @param argument null
     * @return Arc Addon.
     */
    public suspend fun getArcAddon(argument: GetArcAddonPlainArgs): GetArcAddonResult =
        getArcAddonResultToKotlin(getArcAddonPlain(argument.toJava()).await())

    /**
     * @see [getArcAddon].
     * @param addonName The addon name.
     * @param deviceName The device name.
     * @param resourceGroupName The resource group name.
     * @param roleName The role name.
     * @return Arc Addon.
     */
    public suspend fun getArcAddon(
        addonName: String,
        deviceName: String,
        resourceGroupName: String,
        roleName: String,
    ): GetArcAddonResult {
        val argument = GetArcAddonPlainArgs(
            addonName = addonName,
            deviceName = deviceName,
            resourceGroupName = resourceGroupName,
            roleName = roleName,
        )
        return getArcAddonResultToKotlin(getArcAddonPlain(argument.toJava()).await())
    }

    /**
     * @see [getArcAddon].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databoxedge&#46;kotlin&#46;inputs&#46;GetArcAddonPlainArgs].
     * @return Arc Addon.
     */
    public suspend fun getArcAddon(argument: suspend GetArcAddonPlainArgsBuilder.() -> Unit):
        GetArcAddonResult {
        val builder = GetArcAddonPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getArcAddonResultToKotlin(getArcAddonPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified bandwidth schedule.
     * Azure REST API version: 2022-03-01.
     * Other available API versions: 2023-01-01-preview, 2023-07-01, 2023-12-01.
     * @param argument null
     * @return The bandwidth schedule details.
     */
    public suspend fun getBandwidthSchedule(argument: GetBandwidthSchedulePlainArgs):
        GetBandwidthScheduleResult =
        getBandwidthScheduleResultToKotlin(getBandwidthSchedulePlain(argument.toJava()).await())

    /**
     * @see [getBandwidthSchedule].
     * @param deviceName The device name.
     * @param name The bandwidth schedule name.
     * @param resourceGroupName The resource group name.
     * @return The bandwidth schedule details.
     */
    public suspend fun getBandwidthSchedule(
        deviceName: String,
        name: String,
        resourceGroupName: String,
    ): GetBandwidthScheduleResult {
        val argument = GetBandwidthSchedulePlainArgs(
            deviceName = deviceName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getBandwidthScheduleResultToKotlin(getBandwidthSchedulePlain(argument.toJava()).await())
    }

    /**
     * @see [getBandwidthSchedule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databoxedge&#46;kotlin&#46;inputs&#46;GetBandwidthSchedulePlainArgs].
     * @return The bandwidth schedule details.
     */
    public suspend
    fun getBandwidthSchedule(argument: suspend GetBandwidthSchedulePlainArgsBuilder.() -> Unit):
        GetBandwidthScheduleResult {
        val builder = GetBandwidthSchedulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBandwidthScheduleResultToKotlin(getBandwidthSchedulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a specific role by name.
     * Azure REST API version: 2022-03-01.
     * @param argument null
     * @return The preview of Virtual Machine Cloud Management from the Azure supports deploying and managing VMs on your Azure Stack Edge device from Azure Portal.
     * For more information, refer to: https://docs.microsoft.com/en-us/azure/databox-online/azure-stack-edge-gpu-virtual-machine-overview
     * By using this feature, you agree to the preview legal terms. See the https://azure.microsoft.com/en-us/support/legal/preview-supplemental-terms/ for additional details.
     */
    public suspend fun getCloudEdgeManagementRole(argument: GetCloudEdgeManagementRolePlainArgs):
        GetCloudEdgeManagementRoleResult =
        getCloudEdgeManagementRoleResultToKotlin(getCloudEdgeManagementRolePlain(argument.toJava()).await())

    /**
     * @see [getCloudEdgeManagementRole].
     * @param deviceName The device name.
     * @param name The role name.
     * @param resourceGroupName The resource group name.
     * @return The preview of Virtual Machine Cloud Management from the Azure supports deploying and managing VMs on your Azure Stack Edge device from Azure Portal.
     * For more information, refer to: https://docs.microsoft.com/en-us/azure/databox-online/azure-stack-edge-gpu-virtual-machine-overview
     * By using this feature, you agree to the preview legal terms. See the https://azure.microsoft.com/en-us/support/legal/preview-supplemental-terms/ for additional details.
     */
    public suspend fun getCloudEdgeManagementRole(
        deviceName: String,
        name: String,
        resourceGroupName: String,
    ): GetCloudEdgeManagementRoleResult {
        val argument = GetCloudEdgeManagementRolePlainArgs(
            deviceName = deviceName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getCloudEdgeManagementRoleResultToKotlin(getCloudEdgeManagementRolePlain(argument.toJava()).await())
    }

    /**
     * @see [getCloudEdgeManagementRole].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databoxedge&#46;kotlin&#46;inputs&#46;GetCloudEdgeManagementRolePlainArgs].
     * @return The preview of Virtual Machine Cloud Management from the Azure supports deploying and managing VMs on your Azure Stack Edge device from Azure Portal.
     * For more information, refer to: https://docs.microsoft.com/en-us/azure/databox-online/azure-stack-edge-gpu-virtual-machine-overview
     * By using this feature, you agree to the preview legal terms. See the https://azure.microsoft.com/en-us/support/legal/preview-supplemental-terms/ for additional details.
     */
    public suspend
    fun getCloudEdgeManagementRole(argument: suspend GetCloudEdgeManagementRolePlainArgsBuilder.() -> Unit):
        GetCloudEdgeManagementRoleResult {
        val builder = GetCloudEdgeManagementRolePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCloudEdgeManagementRoleResultToKotlin(getCloudEdgeManagementRolePlain(builtArgument.toJava()).await())
    }

    /**
     * Represents a container on the  Data Box Edge/Gateway device.
     * Azure REST API version: 2022-03-01.
     * Other available API versions: 2023-01-01-preview, 2023-07-01, 2023-12-01.
     * @param argument null
     * @return Represents a container on the  Data Box Edge/Gateway device.
     */
    public suspend fun getContainer(argument: GetContainerPlainArgs): GetContainerResult =
        getContainerResultToKotlin(getContainerPlain(argument.toJava()).await())

    /**
     * @see [getContainer].
     * @param containerName The container Name
     * @param deviceName The device name.
     * @param resourceGroupName The resource group name.
     * @param storageAccountName The Storage Account Name
     * @return Represents a container on the  Data Box Edge/Gateway device.
     */
    public suspend fun getContainer(
        containerName: String,
        deviceName: String,
        resourceGroupName: String,
        storageAccountName: String,
    ): GetContainerResult {
        val argument = GetContainerPlainArgs(
            containerName = containerName,
            deviceName = deviceName,
            resourceGroupName = resourceGroupName,
            storageAccountName = storageAccountName,
        )
        return getContainerResultToKotlin(getContainerPlain(argument.toJava()).await())
    }

    /**
     * @see [getContainer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databoxedge&#46;kotlin&#46;inputs&#46;GetContainerPlainArgs].
     * @return Represents a container on the  Data Box Edge/Gateway device.
     */
    public suspend fun getContainer(argument: suspend GetContainerPlainArgsBuilder.() -> Unit):
        GetContainerResult {
        val builder = GetContainerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContainerResultToKotlin(getContainerPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the Data Box Edge/Data Box Gateway device.
     * Azure REST API version: 2022-03-01.
     * Other available API versions: 2020-05-01-preview, 2021-02-01, 2021-02-01-preview, 2022-04-01-preview, 2023-01-01-preview, 2023-07-01, 2023-12-01.
     * @param argument null
     * @return The Data Box Edge/Gateway device.
     */
    public suspend fun getDevice(argument: GetDevicePlainArgs): GetDeviceResult =
        getDeviceResultToKotlin(getDevicePlain(argument.toJava()).await())

    /**
     * @see [getDevice].
     * @param deviceName The device name.
     * @param resourceGroupName The resource group name.
     * @return The Data Box Edge/Gateway device.
     */
    public suspend fun getDevice(deviceName: String, resourceGroupName: String): GetDeviceResult {
        val argument = GetDevicePlainArgs(
            deviceName = deviceName,
            resourceGroupName = resourceGroupName,
        )
        return getDeviceResultToKotlin(getDevicePlain(argument.toJava()).await())
    }

    /**
     * @see [getDevice].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databoxedge&#46;kotlin&#46;inputs&#46;GetDevicePlainArgs].
     * @return The Data Box Edge/Gateway device.
     */
    public suspend fun getDevice(argument: suspend GetDevicePlainArgsBuilder.() -> Unit):
        GetDeviceResult {
        val builder = GetDevicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeviceResultToKotlin(getDevicePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets additional information for the specified Azure Stack Edge/Data Box Gateway device.
     * Azure REST API version: 2022-03-01.
     * Other available API versions: 2020-05-01-preview, 2021-02-01, 2021-02-01-preview, 2022-04-01-preview, 2023-01-01-preview, 2023-07-01, 2023-12-01.
     * @param argument null
     * @return The extended Info of the Data Box Edge/Gateway device.
     */
    public suspend fun getDeviceExtendedInformation(argument: GetDeviceExtendedInformationPlainArgs):
        GetDeviceExtendedInformationResult =
        getDeviceExtendedInformationResultToKotlin(getDeviceExtendedInformationPlain(argument.toJava()).await())

    /**
     * @see [getDeviceExtendedInformation].
     * @param deviceName The device name.
     * @param resourceGroupName The resource group name.
     * @return The extended Info of the Data Box Edge/Gateway device.
     */
    public suspend fun getDeviceExtendedInformation(deviceName: String, resourceGroupName: String):
        GetDeviceExtendedInformationResult {
        val argument = GetDeviceExtendedInformationPlainArgs(
            deviceName = deviceName,
            resourceGroupName = resourceGroupName,
        )
        return getDeviceExtendedInformationResultToKotlin(getDeviceExtendedInformationPlain(argument.toJava()).await())
    }

    /**
     * @see [getDeviceExtendedInformation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databoxedge&#46;kotlin&#46;inputs&#46;GetDeviceExtendedInformationPlainArgs].
     * @return The extended Info of the Data Box Edge/Gateway device.
     */
    public suspend
    fun getDeviceExtendedInformation(argument: suspend GetDeviceExtendedInformationPlainArgsBuilder.() -> Unit):
        GetDeviceExtendedInformationResult {
        val builder = GetDeviceExtendedInformationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeviceExtendedInformationResultToKotlin(getDeviceExtendedInformationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a specific trigger by name.
     * Azure REST API version: 2022-03-01.
     * @param argument null
     * @return Trigger details.
     */
    public suspend fun getFileEventTrigger(argument: GetFileEventTriggerPlainArgs):
        GetFileEventTriggerResult =
        getFileEventTriggerResultToKotlin(getFileEventTriggerPlain(argument.toJava()).await())

    /**
     * @see [getFileEventTrigger].
     * @param deviceName The device name.
     * @param name The trigger name.
     * @param resourceGroupName The resource group name.
     * @return Trigger details.
     */
    public suspend fun getFileEventTrigger(
        deviceName: String,
        name: String,
        resourceGroupName: String,
    ): GetFileEventTriggerResult {
        val argument = GetFileEventTriggerPlainArgs(
            deviceName = deviceName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getFileEventTriggerResultToKotlin(getFileEventTriggerPlain(argument.toJava()).await())
    }

    /**
     * @see [getFileEventTrigger].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databoxedge&#46;kotlin&#46;inputs&#46;GetFileEventTriggerPlainArgs].
     * @return Trigger details.
     */
    public suspend
    fun getFileEventTrigger(argument: suspend GetFileEventTriggerPlainArgsBuilder.() -> Unit):
        GetFileEventTriggerResult {
        val builder = GetFileEventTriggerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFileEventTriggerResultToKotlin(getFileEventTriggerPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a specific addon by name.
     * Azure REST API version: 2022-03-01.
     * @param argument null
     * @return IoT Addon.
     */
    public suspend fun getIoTAddon(argument: GetIoTAddonPlainArgs): GetIoTAddonResult =
        getIoTAddonResultToKotlin(getIoTAddonPlain(argument.toJava()).await())

    /**
     * @see [getIoTAddon].
     * @param addonName The addon name.
     * @param deviceName The device name.
     * @param resourceGroupName The resource group name.
     * @param roleName The role name.
     * @return IoT Addon.
     */
    public suspend fun getIoTAddon(
        addonName: String,
        deviceName: String,
        resourceGroupName: String,
        roleName: String,
    ): GetIoTAddonResult {
        val argument = GetIoTAddonPlainArgs(
            addonName = addonName,
            deviceName = deviceName,
            resourceGroupName = resourceGroupName,
            roleName = roleName,
        )
        return getIoTAddonResultToKotlin(getIoTAddonPlain(argument.toJava()).await())
    }

    /**
     * @see [getIoTAddon].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databoxedge&#46;kotlin&#46;inputs&#46;GetIoTAddonPlainArgs].
     * @return IoT Addon.
     */
    public suspend fun getIoTAddon(argument: suspend GetIoTAddonPlainArgsBuilder.() -> Unit):
        GetIoTAddonResult {
        val builder = GetIoTAddonPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIoTAddonResultToKotlin(getIoTAddonPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a specific role by name.
     * Azure REST API version: 2022-03-01.
     * @param argument null
     * @return Compute role.
     */
    public suspend fun getIoTRole(argument: GetIoTRolePlainArgs): GetIoTRoleResult =
        getIoTRoleResultToKotlin(getIoTRolePlain(argument.toJava()).await())

    /**
     * @see [getIoTRole].
     * @param deviceName The device name.
     * @param name The role name.
     * @param resourceGroupName The resource group name.
     * @return Compute role.
     */
    public suspend fun getIoTRole(
        deviceName: String,
        name: String,
        resourceGroupName: String,
    ): GetIoTRoleResult {
        val argument = GetIoTRolePlainArgs(
            deviceName = deviceName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getIoTRoleResultToKotlin(getIoTRolePlain(argument.toJava()).await())
    }

    /**
     * @see [getIoTRole].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databoxedge&#46;kotlin&#46;inputs&#46;GetIoTRolePlainArgs].
     * @return Compute role.
     */
    public suspend fun getIoTRole(argument: suspend GetIoTRolePlainArgsBuilder.() -> Unit):
        GetIoTRoleResult {
        val builder = GetIoTRolePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIoTRoleResultToKotlin(getIoTRolePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a specific role by name.
     * Azure REST API version: 2022-03-01.
     * @param argument null
     * @return The limited preview of Kubernetes Cluster Management from the Azure supports:
     * 1. Using a simple turn-key option in Azure Portal, deploy a Kubernetes cluster on your Azure Stack Edge device.
     * 2. Configure Kubernetes cluster running on your device with Arc enabled Kubernetes with a click of a button in the Azure Portal.
     *  Azure Arc enables organizations to view, manage, and govern their on-premises Kubernetes clusters using the Azure Portal, command line tools, and APIs.
     * 3. Easily configure Persistent Volumes using SMB and NFS shares for storing container data.
     *  For more information, refer to the document here: https://databoxupdatepackages.blob.core.windows.net/documentation/Microsoft-Azure-Stack-Edge-K8-Cloud-Management-20210323.pdf
     *  Or Demo: https://databoxupdatepackages.blob.core.windows.net/documentation/Microsoft-Azure-Stack-Edge-K8S-Cloud-Management-20210323.mp4
     *  By using this feature, you agree to the preview legal terms. See the https://azure.microsoft.com/en-us/support/legal/preview-supplemental-terms/
     */
    public suspend fun getKubernetesRole(argument: GetKubernetesRolePlainArgs):
        GetKubernetesRoleResult =
        getKubernetesRoleResultToKotlin(getKubernetesRolePlain(argument.toJava()).await())

    /**
     * @see [getKubernetesRole].
     * @param deviceName The device name.
     * @param name The role name.
     * @param resourceGroupName The resource group name.
     * @return The limited preview of Kubernetes Cluster Management from the Azure supports:
     * 1. Using a simple turn-key option in Azure Portal, deploy a Kubernetes cluster on your Azure Stack Edge device.
     * 2. Configure Kubernetes cluster running on your device with Arc enabled Kubernetes with a click of a button in the Azure Portal.
     *  Azure Arc enables organizations to view, manage, and govern their on-premises Kubernetes clusters using the Azure Portal, command line tools, and APIs.
     * 3. Easily configure Persistent Volumes using SMB and NFS shares for storing container data.
     *  For more information, refer to the document here: https://databoxupdatepackages.blob.core.windows.net/documentation/Microsoft-Azure-Stack-Edge-K8-Cloud-Management-20210323.pdf
     *  Or Demo: https://databoxupdatepackages.blob.core.windows.net/documentation/Microsoft-Azure-Stack-Edge-K8S-Cloud-Management-20210323.mp4
     *  By using this feature, you agree to the preview legal terms. See the https://azure.microsoft.com/en-us/support/legal/preview-supplemental-terms/
     */
    public suspend fun getKubernetesRole(
        deviceName: String,
        name: String,
        resourceGroupName: String,
    ): GetKubernetesRoleResult {
        val argument = GetKubernetesRolePlainArgs(
            deviceName = deviceName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getKubernetesRoleResultToKotlin(getKubernetesRolePlain(argument.toJava()).await())
    }

    /**
     * @see [getKubernetesRole].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databoxedge&#46;kotlin&#46;inputs&#46;GetKubernetesRolePlainArgs].
     * @return The limited preview of Kubernetes Cluster Management from the Azure supports:
     * 1. Using a simple turn-key option in Azure Portal, deploy a Kubernetes cluster on your Azure Stack Edge device.
     * 2. Configure Kubernetes cluster running on your device with Arc enabled Kubernetes with a click of a button in the Azure Portal.
     *  Azure Arc enables organizations to view, manage, and govern their on-premises Kubernetes clusters using the Azure Portal, command line tools, and APIs.
     * 3. Easily configure Persistent Volumes using SMB and NFS shares for storing container data.
     *  For more information, refer to the document here: https://databoxupdatepackages.blob.core.windows.net/documentation/Microsoft-Azure-Stack-Edge-K8-Cloud-Management-20210323.pdf
     *  Or Demo: https://databoxupdatepackages.blob.core.windows.net/documentation/Microsoft-Azure-Stack-Edge-K8S-Cloud-Management-20210323.mp4
     *  By using this feature, you agree to the preview legal terms. See the https://azure.microsoft.com/en-us/support/legal/preview-supplemental-terms/
     */
    public suspend
    fun getKubernetesRole(argument: suspend GetKubernetesRolePlainArgsBuilder.() -> Unit):
        GetKubernetesRoleResult {
        val builder = GetKubernetesRolePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKubernetesRoleResultToKotlin(getKubernetesRolePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a specific role by name.
     * Azure REST API version: 2022-03-01.
     * @param argument null
     * @return MEC role.
     */
    public suspend fun getMECRole(argument: GetMECRolePlainArgs): GetMECRoleResult =
        getMECRoleResultToKotlin(getMECRolePlain(argument.toJava()).await())

    /**
     * @see [getMECRole].
     * @param deviceName The device name.
     * @param name The role name.
     * @param resourceGroupName The resource group name.
     * @return MEC role.
     */
    public suspend fun getMECRole(
        deviceName: String,
        name: String,
        resourceGroupName: String,
    ): GetMECRoleResult {
        val argument = GetMECRolePlainArgs(
            deviceName = deviceName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getMECRoleResultToKotlin(getMECRolePlain(argument.toJava()).await())
    }

    /**
     * @see [getMECRole].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databoxedge&#46;kotlin&#46;inputs&#46;GetMECRolePlainArgs].
     * @return MEC role.
     */
    public suspend fun getMECRole(argument: suspend GetMECRolePlainArgsBuilder.() -> Unit):
        GetMECRoleResult {
        val builder = GetMECRolePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMECRoleResultToKotlin(getMECRolePlain(builtArgument.toJava()).await())
    }

    /**
     * The metric setting details for the role
     * Azure REST API version: 2022-03-01.
     * Other available API versions: 2023-01-01-preview, 2023-07-01, 2023-12-01.
     * @param argument null
     * @return The metric setting details for the role
     */
    public suspend fun getMonitoringConfig(argument: GetMonitoringConfigPlainArgs):
        GetMonitoringConfigResult =
        getMonitoringConfigResultToKotlin(getMonitoringConfigPlain(argument.toJava()).await())

    /**
     * @see [getMonitoringConfig].
     * @param deviceName The device name.
     * @param resourceGroupName The resource group name.
     * @param roleName The role name.
     * @return The metric setting details for the role
     */
    public suspend fun getMonitoringConfig(
        deviceName: String,
        resourceGroupName: String,
        roleName: String,
    ): GetMonitoringConfigResult {
        val argument = GetMonitoringConfigPlainArgs(
            deviceName = deviceName,
            resourceGroupName = resourceGroupName,
            roleName = roleName,
        )
        return getMonitoringConfigResultToKotlin(getMonitoringConfigPlain(argument.toJava()).await())
    }

    /**
     * @see [getMonitoringConfig].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databoxedge&#46;kotlin&#46;inputs&#46;GetMonitoringConfigPlainArgs].
     * @return The metric setting details for the role
     */
    public suspend
    fun getMonitoringConfig(argument: suspend GetMonitoringConfigPlainArgsBuilder.() -> Unit):
        GetMonitoringConfigResult {
        val builder = GetMonitoringConfigPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMonitoringConfigResultToKotlin(getMonitoringConfigPlain(builtArgument.toJava()).await())
    }

    /**
     * The order details.
     * Azure REST API version: 2022-03-01.
     * Other available API versions: 2020-05-01-preview, 2022-04-01-preview, 2023-01-01-preview, 2023-07-01, 2023-12-01.
     * @param argument null
     * @return The order details.
     */
    public suspend fun getOrder(argument: GetOrderPlainArgs): GetOrderResult =
        getOrderResultToKotlin(getOrderPlain(argument.toJava()).await())

    /**
     * @see [getOrder].
     * @param deviceName The device name.
     * @param resourceGroupName The resource group name.
     * @return The order details.
     */
    public suspend fun getOrder(deviceName: String, resourceGroupName: String): GetOrderResult {
        val argument = GetOrderPlainArgs(
            deviceName = deviceName,
            resourceGroupName = resourceGroupName,
        )
        return getOrderResultToKotlin(getOrderPlain(argument.toJava()).await())
    }

    /**
     * @see [getOrder].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databoxedge&#46;kotlin&#46;inputs&#46;GetOrderPlainArgs].
     * @return The order details.
     */
    public suspend fun getOrder(argument: suspend GetOrderPlainArgsBuilder.() -> Unit):
        GetOrderResult {
        val builder = GetOrderPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOrderResultToKotlin(getOrderPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a specific trigger by name.
     * Azure REST API version: 2022-03-01.
     * @param argument null
     * @return Trigger details.
     */
    public suspend fun getPeriodicTimerEventTrigger(argument: GetPeriodicTimerEventTriggerPlainArgs):
        GetPeriodicTimerEventTriggerResult =
        getPeriodicTimerEventTriggerResultToKotlin(getPeriodicTimerEventTriggerPlain(argument.toJava()).await())

    /**
     * @see [getPeriodicTimerEventTrigger].
     * @param deviceName The device name.
     * @param name The trigger name.
     * @param resourceGroupName The resource group name.
     * @return Trigger details.
     */
    public suspend fun getPeriodicTimerEventTrigger(
        deviceName: String,
        name: String,
        resourceGroupName: String,
    ): GetPeriodicTimerEventTriggerResult {
        val argument = GetPeriodicTimerEventTriggerPlainArgs(
            deviceName = deviceName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getPeriodicTimerEventTriggerResultToKotlin(getPeriodicTimerEventTriggerPlain(argument.toJava()).await())
    }

    /**
     * @see [getPeriodicTimerEventTrigger].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databoxedge&#46;kotlin&#46;inputs&#46;GetPeriodicTimerEventTriggerPlainArgs].
     * @return Trigger details.
     */
    public suspend
    fun getPeriodicTimerEventTrigger(argument: suspend GetPeriodicTimerEventTriggerPlainArgsBuilder.() -> Unit):
        GetPeriodicTimerEventTriggerResult {
        val builder = GetPeriodicTimerEventTriggerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPeriodicTimerEventTriggerResultToKotlin(getPeriodicTimerEventTriggerPlain(builtArgument.toJava()).await())
    }

    /**
     * Represents a share on the  Data Box Edge/Gateway device.
     * Azure REST API version: 2022-03-01.
     * Other available API versions: 2023-01-01-preview, 2023-07-01, 2023-12-01.
     * @param argument null
     * @return Represents a share on the  Data Box Edge/Gateway device.
     */
    public suspend fun getShare(argument: GetSharePlainArgs): GetShareResult =
        getShareResultToKotlin(getSharePlain(argument.toJava()).await())

    /**
     * @see [getShare].
     * @param deviceName The device name.
     * @param name The share name.
     * @param resourceGroupName The resource group name.
     * @return Represents a share on the  Data Box Edge/Gateway device.
     */
    public suspend fun getShare(
        deviceName: String,
        name: String,
        resourceGroupName: String,
    ): GetShareResult {
        val argument = GetSharePlainArgs(
            deviceName = deviceName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getShareResultToKotlin(getSharePlain(argument.toJava()).await())
    }

    /**
     * @see [getShare].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databoxedge&#46;kotlin&#46;inputs&#46;GetSharePlainArgs].
     * @return Represents a share on the  Data Box Edge/Gateway device.
     */
    public suspend fun getShare(argument: suspend GetSharePlainArgsBuilder.() -> Unit):
        GetShareResult {
        val builder = GetSharePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getShareResultToKotlin(getSharePlain(builtArgument.toJava()).await())
    }

    /**
     * Represents a Storage Account on the  Data Box Edge/Gateway device.
     * Azure REST API version: 2022-03-01.
     * Other available API versions: 2020-05-01-preview, 2023-01-01-preview, 2023-07-01, 2023-12-01.
     * @param argument null
     * @return Represents a Storage Account on the  Data Box Edge/Gateway device.
     */
    public suspend fun getStorageAccount(argument: GetStorageAccountPlainArgs):
        GetStorageAccountResult =
        getStorageAccountResultToKotlin(getStorageAccountPlain(argument.toJava()).await())

    /**
     * @see [getStorageAccount].
     * @param deviceName The device name.
     * @param resourceGroupName The resource group name.
     * @param storageAccountName The storage account name.
     * @return Represents a Storage Account on the  Data Box Edge/Gateway device.
     */
    public suspend fun getStorageAccount(
        deviceName: String,
        resourceGroupName: String,
        storageAccountName: String,
    ): GetStorageAccountResult {
        val argument = GetStorageAccountPlainArgs(
            deviceName = deviceName,
            resourceGroupName = resourceGroupName,
            storageAccountName = storageAccountName,
        )
        return getStorageAccountResultToKotlin(getStorageAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getStorageAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databoxedge&#46;kotlin&#46;inputs&#46;GetStorageAccountPlainArgs].
     * @return Represents a Storage Account on the  Data Box Edge/Gateway device.
     */
    public suspend
    fun getStorageAccount(argument: suspend GetStorageAccountPlainArgsBuilder.() -> Unit):
        GetStorageAccountResult {
        val builder = GetStorageAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStorageAccountResultToKotlin(getStorageAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified storage account credential.
     * Azure REST API version: 2022-03-01.
     * Other available API versions: 2023-01-01-preview, 2023-07-01, 2023-12-01.
     * @param argument null
     * @return The storage account credential.
     */
    public suspend fun getStorageAccountCredential(argument: GetStorageAccountCredentialPlainArgs):
        GetStorageAccountCredentialResult =
        getStorageAccountCredentialResultToKotlin(getStorageAccountCredentialPlain(argument.toJava()).await())

    /**
     * @see [getStorageAccountCredential].
     * @param deviceName The device name.
     * @param name The storage account credential name.
     * @param resourceGroupName The resource group name.
     * @return The storage account credential.
     */
    public suspend fun getStorageAccountCredential(
        deviceName: String,
        name: String,
        resourceGroupName: String,
    ): GetStorageAccountCredentialResult {
        val argument = GetStorageAccountCredentialPlainArgs(
            deviceName = deviceName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getStorageAccountCredentialResultToKotlin(getStorageAccountCredentialPlain(argument.toJava()).await())
    }

    /**
     * @see [getStorageAccountCredential].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databoxedge&#46;kotlin&#46;inputs&#46;GetStorageAccountCredentialPlainArgs].
     * @return The storage account credential.
     */
    public suspend
    fun getStorageAccountCredential(argument: suspend GetStorageAccountCredentialPlainArgsBuilder.() -> Unit):
        GetStorageAccountCredentialResult {
        val builder = GetStorageAccountCredentialPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStorageAccountCredentialResultToKotlin(getStorageAccountCredentialPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified user.
     * Azure REST API version: 2022-03-01.
     * Other available API versions: 2019-07-01, 2019-08-01, 2021-02-01-preview, 2023-01-01-preview, 2023-07-01, 2023-12-01.
     * @param argument null
     * @return Represents a user who has access to one or more shares on the Data Box Edge/Gateway device.
     */
    public suspend fun getUser(argument: GetUserPlainArgs): GetUserResult =
        getUserResultToKotlin(getUserPlain(argument.toJava()).await())

    /**
     * @see [getUser].
     * @param deviceName The device name.
     * @param name The user name.
     * @param resourceGroupName The resource group name.
     * @return Represents a user who has access to one or more shares on the Data Box Edge/Gateway device.
     */
    public suspend fun getUser(
        deviceName: String,
        name: String,
        resourceGroupName: String,
    ): GetUserResult {
        val argument = GetUserPlainArgs(
            deviceName = deviceName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getUserResultToKotlin(getUserPlain(argument.toJava()).await())
    }

    /**
     * @see [getUser].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databoxedge&#46;kotlin&#46;inputs&#46;GetUserPlainArgs].
     * @return Represents a user who has access to one or more shares on the Data Box Edge/Gateway device.
     */
    public suspend fun getUser(argument: suspend GetUserPlainArgsBuilder.() -> Unit): GetUserResult {
        val builder = GetUserPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserResultToKotlin(getUserPlain(builtArgument.toJava()).await())
    }

    /**
     * DC Access code in the case of Self Managed Shipping.
     * Azure REST API version: 2022-03-01.
     * Other available API versions: 2022-04-01-preview, 2023-01-01-preview, 2023-07-01, 2023-12-01.
     * @param argument null
     * @return DC Access code in the case of Self Managed Shipping.
     */
    public suspend fun listOrderDCAccessCode(argument: ListOrderDCAccessCodePlainArgs):
        ListOrderDCAccessCodeResult =
        listOrderDCAccessCodeResultToKotlin(listOrderDCAccessCodePlain(argument.toJava()).await())

    /**
     * @see [listOrderDCAccessCode].
     * @param deviceName The device name
     * @param resourceGroupName The resource group name.
     * @return DC Access code in the case of Self Managed Shipping.
     */
    public suspend fun listOrderDCAccessCode(deviceName: String, resourceGroupName: String):
        ListOrderDCAccessCodeResult {
        val argument = ListOrderDCAccessCodePlainArgs(
            deviceName = deviceName,
            resourceGroupName = resourceGroupName,
        )
        return listOrderDCAccessCodeResultToKotlin(listOrderDCAccessCodePlain(argument.toJava()).await())
    }

    /**
     * @see [listOrderDCAccessCode].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databoxedge&#46;kotlin&#46;inputs&#46;ListOrderDCAccessCodePlainArgs].
     * @return DC Access code in the case of Self Managed Shipping.
     */
    public suspend
    fun listOrderDCAccessCode(argument: suspend ListOrderDCAccessCodePlainArgsBuilder.() -> Unit):
        ListOrderDCAccessCodeResult {
        val builder = ListOrderDCAccessCodePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listOrderDCAccessCodeResultToKotlin(listOrderDCAccessCodePlain(builtArgument.toJava()).await())
    }
}
