@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.IoTAddonArgs.builder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.IoTDeviceInfoArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.IoTDeviceInfoArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * IoT Addon.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * ## Example Usage
 * ### PutAddOns
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ioTAddon = new AzureNative.DataBoxEdge.IoTAddon("ioTAddon", new()
 *     {
 *         AddonName = "arcName",
 *         DeviceName = "testedgedevice",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         RoleName = "KubernetesRole",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewIoTAddon(ctx, "ioTAddon", &databoxedge.IoTAddonArgs{
 * 			AddonName:         pulumi.String("arcName"),
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			RoleName:          pulumi.String("KubernetesRole"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.IoTAddon;
 * import com.pulumi.azurenative.databoxedge.IoTAddonArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ioTAddon = new IoTAddon("ioTAddon", IoTAddonArgs.builder()
 *             .addonName("arcName")
 *             .deviceName("testedgedevice")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .roleName("KubernetesRole")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:IoTAddon arcName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/roles/{roleName}/addons/{addonName}
 * ```
 * @property addonName The addon name.
 * @property deviceName The device name.
 * @property ioTDeviceDetails IoT device metadata to which appliance needs to be connected.
 * @property ioTEdgeDeviceDetails IoT edge device to which the IoT Addon needs to be configured.
 * @property kind Addon type.
 * Expected value is 'IotEdge'.
 * @property resourceGroupName The resource group name.
 * @property roleName The role name.
 */
public data class IoTAddonArgs(
    public val addonName: Output<String>? = null,
    public val deviceName: Output<String>? = null,
    public val ioTDeviceDetails: Output<IoTDeviceInfoArgs>? = null,
    public val ioTEdgeDeviceDetails: Output<IoTDeviceInfoArgs>? = null,
    public val kind: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val roleName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.IoTAddonArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.IoTAddonArgs =
        com.pulumi.azurenative.databoxedge.IoTAddonArgs.builder()
            .addonName(addonName?.applyValue({ args0 -> args0 }))
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .ioTDeviceDetails(ioTDeviceDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ioTEdgeDeviceDetails(
                ioTEdgeDeviceDetails?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kind(kind?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .roleName(roleName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IoTAddonArgs].
 */
@PulumiTagMarker
public class IoTAddonArgsBuilder internal constructor() {
    private var addonName: Output<String>? = null

    private var deviceName: Output<String>? = null

    private var ioTDeviceDetails: Output<IoTDeviceInfoArgs>? = null

    private var ioTEdgeDeviceDetails: Output<IoTDeviceInfoArgs>? = null

    private var kind: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var roleName: Output<String>? = null

    /**
     * @param value The addon name.
     */
    @JvmName("tgparwghrdqohkac")
    public suspend fun addonName(`value`: Output<String>) {
        this.addonName = value
    }

    /**
     * @param value The device name.
     */
    @JvmName("jmgylqfxrhsiqiay")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value IoT device metadata to which appliance needs to be connected.
     */
    @JvmName("nhocwdosqnisjtga")
    public suspend fun ioTDeviceDetails(`value`: Output<IoTDeviceInfoArgs>) {
        this.ioTDeviceDetails = value
    }

    /**
     * @param value IoT edge device to which the IoT Addon needs to be configured.
     */
    @JvmName("sehfcpmtctfrqqam")
    public suspend fun ioTEdgeDeviceDetails(`value`: Output<IoTDeviceInfoArgs>) {
        this.ioTEdgeDeviceDetails = value
    }

    /**
     * @param value Addon type.
     * Expected value is 'IotEdge'.
     */
    @JvmName("spkpabceimkuwrdn")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("ehqleqiqwdbndoxw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The role name.
     */
    @JvmName("ltgglxpmpmtqdpoe")
    public suspend fun roleName(`value`: Output<String>) {
        this.roleName = value
    }

    /**
     * @param value The addon name.
     */
    @JvmName("cpoafkgjmklkljqm")
    public suspend fun addonName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addonName = mapped
    }

    /**
     * @param value The device name.
     */
    @JvmName("lpqtcdhrmlmgxaat")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value IoT device metadata to which appliance needs to be connected.
     */
    @JvmName("kjbuimcogdhhyqlr")
    public suspend fun ioTDeviceDetails(`value`: IoTDeviceInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ioTDeviceDetails = mapped
    }

    /**
     * @param argument IoT device metadata to which appliance needs to be connected.
     */
    @JvmName("wwxmqqbuvecrhvxy")
    public suspend fun ioTDeviceDetails(argument: suspend IoTDeviceInfoArgsBuilder.() -> Unit) {
        val toBeMapped = IoTDeviceInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ioTDeviceDetails = mapped
    }

    /**
     * @param value IoT edge device to which the IoT Addon needs to be configured.
     */
    @JvmName("phafriqwmtofgufc")
    public suspend fun ioTEdgeDeviceDetails(`value`: IoTDeviceInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ioTEdgeDeviceDetails = mapped
    }

    /**
     * @param argument IoT edge device to which the IoT Addon needs to be configured.
     */
    @JvmName("bkcnlngsqmbawswf")
    public suspend fun ioTEdgeDeviceDetails(argument: suspend IoTDeviceInfoArgsBuilder.() -> Unit) {
        val toBeMapped = IoTDeviceInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ioTEdgeDeviceDetails = mapped
    }

    /**
     * @param value Addon type.
     * Expected value is 'IotEdge'.
     */
    @JvmName("ahguscorhyhekuxb")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("qvkpibemmoljrvme")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The role name.
     */
    @JvmName("cgcjoidicrrdvsqn")
    public suspend fun roleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleName = mapped
    }

    internal fun build(): IoTAddonArgs = IoTAddonArgs(
        addonName = addonName,
        deviceName = deviceName,
        ioTDeviceDetails = ioTDeviceDetails,
        ioTEdgeDeviceDetails = ioTEdgeDeviceDetails,
        kind = kind,
        resourceGroupName = resourceGroupName,
        roleName = roleName,
    )
}
