@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.kotlin.outputs.AddressResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.ContactDetailsResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.OrderStatusResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.TrackingInfoResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.databoxedge.kotlin.outputs.AddressResponse.Companion.toKotlin as addressResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.ContactDetailsResponse.Companion.toKotlin as contactDetailsResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.OrderStatusResponse.Companion.toKotlin as orderStatusResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.TrackingInfoResponse.Companion.toKotlin as trackingInfoResponseToKotlin

/**
 * Builder for [Order].
 */
@PulumiTagMarker
public class OrderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrderArgs = OrderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrderArgsBuilder.() -> Unit) {
        val builder = OrderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Order {
        val builtJavaResource = com.pulumi.azurenative.databoxedge.Order(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Order(builtJavaResource)
    }
}

/**
 * The order details.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-05-01-preview, 2022-04-01-preview, 2023-01-01-preview, 2023-07-01, 2023-12-01.
 * ## Example Usage
 * ### OrderPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var order = new AzureNative.DataBoxEdge.Order("order", new()
 *     {
 *         ContactInformation = new AzureNative.DataBoxEdge.Inputs.ContactDetailsArgs
 *         {
 *             CompanyName = "Microsoft",
 *             ContactPerson = "John Mcclane",
 *             EmailList = new[]
 *             {
 *                 "john@microsoft.com",
 *             },
 *             Phone = "(800) 426-9400",
 *         },
 *         DeviceName = "testedgedevice",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         ShippingAddress = new AzureNative.DataBoxEdge.Inputs.AddressArgs
 *         {
 *             AddressLine1 = "Microsoft Corporation",
 *             AddressLine2 = "One Microsoft Way",
 *             AddressLine3 = "Redmond",
 *             City = "WA",
 *             Country = "USA",
 *             PostalCode = "98052",
 *             State = "WA",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewOrder(ctx, "order", &databoxedge.OrderArgs{
 * 			ContactInformation: &databoxedge.ContactDetailsArgs{
 * 				CompanyName:   pulumi.String("Microsoft"),
 * 				ContactPerson: pulumi.String("John Mcclane"),
 * 				EmailList: pulumi.StringArray{
 * 					pulumi.String("john@microsoft.com"),
 * 				},
 * 				Phone: pulumi.String("(800) 426-9400"),
 * 			},
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			ShippingAddress: &databoxedge.AddressArgs{
 * 				AddressLine1: pulumi.String("Microsoft Corporation"),
 * 				AddressLine2: pulumi.String("One Microsoft Way"),
 * 				AddressLine3: pulumi.String("Redmond"),
 * 				City:         pulumi.String("WA"),
 * 				Country:      pulumi.String("USA"),
 * 				PostalCode:   pulumi.String("98052"),
 * 				State:        pulumi.String("WA"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.Order;
 * import com.pulumi.azurenative.databoxedge.OrderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var order = new Order("order", OrderArgs.builder()
 *             .contactInformation(Map.ofEntries(
 *                 Map.entry("companyName", "Microsoft"),
 *                 Map.entry("contactPerson", "John Mcclane"),
 *                 Map.entry("emailList", "john@microsoft.com"),
 *                 Map.entry("phone", "(800) 426-9400")
 *             ))
 *             .deviceName("testedgedevice")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .shippingAddress(Map.ofEntries(
 *                 Map.entry("addressLine1", "Microsoft Corporation"),
 *                 Map.entry("addressLine2", "One Microsoft Way"),
 *                 Map.entry("addressLine3", "Redmond"),
 *                 Map.entry("city", "WA"),
 *                 Map.entry("country", "USA"),
 *                 Map.entry("postalCode", "98052"),
 *                 Map.entry("state", "WA")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:Order default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/orders/default
 * ```
 */
public class Order internal constructor(
    override val javaResource: com.pulumi.azurenative.databoxedge.Order,
) : KotlinCustomResource(javaResource, OrderMapper) {
    /**
     * The contact details.
     */
    public val contactInformation: Output<ContactDetailsResponse>
        get() = javaResource.contactInformation().applyValue({ args0 ->
            args0.let({ args0 ->
                contactDetailsResponseToKotlin(args0)
            })
        })

    /**
     * Current status of the order.
     */
    public val currentStatus: Output<OrderStatusResponse>
        get() = javaResource.currentStatus().applyValue({ args0 ->
            args0.let({ args0 ->
                orderStatusResponseToKotlin(args0)
            })
        })

    /**
     * Tracking information for the package delivered to the customer whether it has an original or a replacement device.
     */
    public val deliveryTrackingInfo: Output<List<TrackingInfoResponse>>
        get() = javaResource.deliveryTrackingInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> trackingInfoResponseToKotlin(args0) })
            })
        })

    /**
     * It specify the order api version.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The object name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of status changes in the order.
     */
    public val orderHistory: Output<List<OrderStatusResponse>>
        get() = javaResource.orderHistory().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    orderStatusResponseToKotlin(args0)
                })
            })
        })

    /**
     * It specify the order resource id.
     */
    public val orderId: Output<String>
        get() = javaResource.orderId().applyValue({ args0 -> args0 })

    /**
     * Tracking information for the package returned from the customer whether it has an original or a replacement device.
     */
    public val returnTrackingInfo: Output<List<TrackingInfoResponse>>
        get() = javaResource.returnTrackingInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> trackingInfoResponseToKotlin(args0) })
            })
        })

    /**
     * Serial number of the device.
     */
    public val serialNumber: Output<String>
        get() = javaResource.serialNumber().applyValue({ args0 -> args0 })

    /**
     * ShipmentType of the order
     */
    public val shipmentType: Output<String>?
        get() = javaResource.shipmentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The shipping address.
     */
    public val shippingAddress: Output<AddressResponse>?
        get() = javaResource.shippingAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> addressResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of Order
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object OrderMapper : ResourceMapper<Order> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databoxedge.Order::class == javaResource::class

    override fun map(javaResource: Resource): Order = Order(
        javaResource as
            com.pulumi.azurenative.databoxedge.Order,
    )
}

/**
 * @see [Order].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Order].
 */
public suspend fun order(name: String, block: suspend OrderResourceBuilder.() -> Unit): Order {
    val builder = OrderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Order].
 * @param name The _unique_ name of the resulting resource.
 */
public fun order(name: String): Order {
    val builder = OrderResourceBuilder()
    builder.name(name)
    return builder.build()
}
