@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.PeriodicTimerEventTriggerArgs.builder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.PeriodicTimerSourceInfoArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.PeriodicTimerSourceInfoArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.RoleSinkInfoArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.RoleSinkInfoArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Trigger details.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * ## Example Usage
 * ### TriggerPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var periodicTimerEventTrigger = new AzureNative.DataBoxEdge.PeriodicTimerEventTrigger("periodicTimerEventTrigger", new()
 *     {
 *         DeviceName = "testedgedevice",
 *         Name = "trigger1",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewPeriodicTimerEventTrigger(ctx, "periodicTimerEventTrigger", &databoxedge.PeriodicTimerEventTriggerArgs{
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			Name:              pulumi.String("trigger1"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.PeriodicTimerEventTrigger;
 * import com.pulumi.azurenative.databoxedge.PeriodicTimerEventTriggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var periodicTimerEventTrigger = new PeriodicTimerEventTrigger("periodicTimerEventTrigger", PeriodicTimerEventTriggerArgs.builder()
 *             .deviceName("testedgedevice")
 *             .name("trigger1")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:PeriodicTimerEventTrigger trigger1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/triggers/{name}
 * ```
 * @property customContextTag A custom context tag typically used to correlate the trigger against its usage. For example, if a periodic timer trigger is intended for certain specific IoT modules in the device, the tag can be the name or the image URL of the module.
 * @property deviceName Creates or updates a trigger
 * @property kind Trigger Kind.
 * Expected value is 'PeriodicTimerEvent'.
 * @property name The trigger name.
 * @property resourceGroupName The resource group name.
 * @property sinkInfo Role Sink information.
 * @property sourceInfo Periodic timer details.
 */
public data class PeriodicTimerEventTriggerArgs(
    public val customContextTag: Output<String>? = null,
    public val deviceName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sinkInfo: Output<RoleSinkInfoArgs>? = null,
    public val sourceInfo: Output<PeriodicTimerSourceInfoArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.PeriodicTimerEventTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.PeriodicTimerEventTriggerArgs =
        com.pulumi.azurenative.databoxedge.PeriodicTimerEventTriggerArgs.builder()
            .customContextTag(customContextTag?.applyValue({ args0 -> args0 }))
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sinkInfo(sinkInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceInfo(sourceInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PeriodicTimerEventTriggerArgs].
 */
@PulumiTagMarker
public class PeriodicTimerEventTriggerArgsBuilder internal constructor() {
    private var customContextTag: Output<String>? = null

    private var deviceName: Output<String>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sinkInfo: Output<RoleSinkInfoArgs>? = null

    private var sourceInfo: Output<PeriodicTimerSourceInfoArgs>? = null

    /**
     * @param value A custom context tag typically used to correlate the trigger against its usage. For example, if a periodic timer trigger is intended for certain specific IoT modules in the device, the tag can be the name or the image URL of the module.
     */
    @JvmName("gniufrjljtpvbito")
    public suspend fun customContextTag(`value`: Output<String>) {
        this.customContextTag = value
    }

    /**
     * @param value Creates or updates a trigger
     */
    @JvmName("pegwhtmkureqhxvs")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value Trigger Kind.
     * Expected value is 'PeriodicTimerEvent'.
     */
    @JvmName("xveuxkqaapdwvwkw")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The trigger name.
     */
    @JvmName("liyrqiwbjfhrnaxt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("yhmnobbvhvgvaigw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Role Sink information.
     */
    @JvmName("godqvqnknnfbusmc")
    public suspend fun sinkInfo(`value`: Output<RoleSinkInfoArgs>) {
        this.sinkInfo = value
    }

    /**
     * @param value Periodic timer details.
     */
    @JvmName("urloedgmlvxgohyq")
    public suspend fun sourceInfo(`value`: Output<PeriodicTimerSourceInfoArgs>) {
        this.sourceInfo = value
    }

    /**
     * @param value A custom context tag typically used to correlate the trigger against its usage. For example, if a periodic timer trigger is intended for certain specific IoT modules in the device, the tag can be the name or the image URL of the module.
     */
    @JvmName("dvjoewoauuhpcgip")
    public suspend fun customContextTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customContextTag = mapped
    }

    /**
     * @param value Creates or updates a trigger
     */
    @JvmName("fmumuwpqmgolnhxl")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value Trigger Kind.
     * Expected value is 'PeriodicTimerEvent'.
     */
    @JvmName("jpvucnjnockvrqif")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The trigger name.
     */
    @JvmName("yprwvsrowbkjsgyp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("rpweofwwldgmvmxd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Role Sink information.
     */
    @JvmName("ypdsxarxmokdbgjk")
    public suspend fun sinkInfo(`value`: RoleSinkInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkInfo = mapped
    }

    /**
     * @param argument Role Sink information.
     */
    @JvmName("lfsrvflbgqovlfmb")
    public suspend fun sinkInfo(argument: suspend RoleSinkInfoArgsBuilder.() -> Unit) {
        val toBeMapped = RoleSinkInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sinkInfo = mapped
    }

    /**
     * @param value Periodic timer details.
     */
    @JvmName("vdibevnivvevcjtx")
    public suspend fun sourceInfo(`value`: PeriodicTimerSourceInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceInfo = mapped
    }

    /**
     * @param argument Periodic timer details.
     */
    @JvmName("ewhsrayfvdksolsr")
    public suspend fun sourceInfo(argument: suspend PeriodicTimerSourceInfoArgsBuilder.() -> Unit) {
        val toBeMapped = PeriodicTimerSourceInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceInfo = mapped
    }

    internal fun build(): PeriodicTimerEventTriggerArgs = PeriodicTimerEventTriggerArgs(
        customContextTag = customContextTag,
        deviceName = deviceName,
        kind = kind,
        name = name,
        resourceGroupName = resourceGroupName,
        sinkInfo = sinkInfo,
        sourceInfo = sourceInfo,
    )
}
