@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.StorageAccountArgs.builder
import com.pulumi.azurenative.databoxedge.kotlin.enums.DataPolicy
import com.pulumi.azurenative.databoxedge.kotlin.enums.StorageAccountStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a Storage Account on the  Data Box Edge/Gateway device.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-05-01-preview, 2023-01-01-preview, 2023-07-01, 2023-12-01.
 * ## Example Usage
 * ### StorageAccountPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.DataBoxEdge.StorageAccount("storageAccount", new()
 *     {
 *         DataPolicy = "Cloud",
 *         Description = "It's an awesome storage account",
 *         DeviceName = "testedgedevice",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         StorageAccountCredentialId = "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForDataBoxEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/storageAccountCredentials/cisbvt",
 *         StorageAccountName = "blobstorageaccount1",
 *         StorageAccountStatus = "OK",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewStorageAccount(ctx, "storageAccount", &databoxedge.StorageAccountArgs{
 * 			DataPolicy:                 pulumi.String("Cloud"),
 * 			Description:                pulumi.String("It's an awesome storage account"),
 * 			DeviceName:                 pulumi.String("testedgedevice"),
 * 			ResourceGroupName:          pulumi.String("GroupForEdgeAutomation"),
 * 			StorageAccountCredentialId: pulumi.String("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForDataBoxEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/storageAccountCredentials/cisbvt"),
 * 			StorageAccountName:         pulumi.String("blobstorageaccount1"),
 * 			StorageAccountStatus:       pulumi.String("OK"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.StorageAccount;
 * import com.pulumi.azurenative.databoxedge.StorageAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .dataPolicy("Cloud")
 *             .description("It's an awesome storage account")
 *             .deviceName("testedgedevice")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .storageAccountCredentialId("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForDataBoxEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/storageAccountCredentials/cisbvt")
 *             .storageAccountName("blobstorageaccount1")
 *             .storageAccountStatus("OK")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:StorageAccount blobstorageaccount1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/storageAccounts/{storageAccountName}
 * ```
 * @property dataPolicy Data policy of the storage Account.
 * @property description Description for the storage Account.
 * @property deviceName The device name.
 * @property resourceGroupName The resource group name.
 * @property storageAccountCredentialId Storage Account Credential Id
 * @property storageAccountName The StorageAccount name.
 * @property storageAccountStatus Current status of the storage account
 */
public data class StorageAccountArgs(
    public val dataPolicy: Output<Either<String, DataPolicy>>? = null,
    public val description: Output<String>? = null,
    public val deviceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageAccountCredentialId: Output<String>? = null,
    public val storageAccountName: Output<String>? = null,
    public val storageAccountStatus: Output<Either<String, StorageAccountStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.StorageAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.StorageAccountArgs =
        com.pulumi.azurenative.databoxedge.StorageAccountArgs.builder()
            .dataPolicy(
                dataPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageAccountCredentialId(storageAccountCredentialId?.applyValue({ args0 -> args0 }))
            .storageAccountName(storageAccountName?.applyValue({ args0 -> args0 }))
            .storageAccountStatus(
                storageAccountStatus?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [StorageAccountArgs].
 */
@PulumiTagMarker
public class StorageAccountArgsBuilder internal constructor() {
    private var dataPolicy: Output<Either<String, DataPolicy>>? = null

    private var description: Output<String>? = null

    private var deviceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageAccountCredentialId: Output<String>? = null

    private var storageAccountName: Output<String>? = null

    private var storageAccountStatus: Output<Either<String, StorageAccountStatus>>? = null

    /**
     * @param value Data policy of the storage Account.
     */
    @JvmName("yuggoxqipamoayew")
    public suspend fun dataPolicy(`value`: Output<Either<String, DataPolicy>>) {
        this.dataPolicy = value
    }

    /**
     * @param value Description for the storage Account.
     */
    @JvmName("jaoybgwugyseidty")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The device name.
     */
    @JvmName("cdewyegrekeigqys")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("jisypybvcxrolqys")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Storage Account Credential Id
     */
    @JvmName("auqlwcrqwlbfraww")
    public suspend fun storageAccountCredentialId(`value`: Output<String>) {
        this.storageAccountCredentialId = value
    }

    /**
     * @param value The StorageAccount name.
     */
    @JvmName("ljqvthiqkrmpculs")
    public suspend fun storageAccountName(`value`: Output<String>) {
        this.storageAccountName = value
    }

    /**
     * @param value Current status of the storage account
     */
    @JvmName("ugmbsjvinufdesrw")
    public suspend fun storageAccountStatus(`value`: Output<Either<String, StorageAccountStatus>>) {
        this.storageAccountStatus = value
    }

    /**
     * @param value Data policy of the storage Account.
     */
    @JvmName("geasduclgwknmoqo")
    public suspend fun dataPolicy(`value`: Either<String, DataPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPolicy = mapped
    }

    /**
     * @param value Data policy of the storage Account.
     */
    @JvmName("qxxlcgrgyaddrffm")
    public fun dataPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataPolicy = mapped
    }

    /**
     * @param value Data policy of the storage Account.
     */
    @JvmName("phyvgimsjmdkulsf")
    public fun dataPolicy(`value`: DataPolicy) {
        val toBeMapped = Either.ofRight<String, DataPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataPolicy = mapped
    }

    /**
     * @param value Description for the storage Account.
     */
    @JvmName("qmtrepmjmllkejwe")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The device name.
     */
    @JvmName("ykygitlnwwsantem")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("qpgdfxclawaboqlc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Storage Account Credential Id
     */
    @JvmName("qymwiyppvearupwa")
    public suspend fun storageAccountCredentialId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountCredentialId = mapped
    }

    /**
     * @param value The StorageAccount name.
     */
    @JvmName("ujnqithteumpmlgg")
    public suspend fun storageAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountName = mapped
    }

    /**
     * @param value Current status of the storage account
     */
    @JvmName("yvwkckghqqjgkqha")
    public suspend fun storageAccountStatus(`value`: Either<String, StorageAccountStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountStatus = mapped
    }

    /**
     * @param value Current status of the storage account
     */
    @JvmName("huxvijfpkajuwbot")
    public fun storageAccountStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageAccountStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountStatus = mapped
    }

    /**
     * @param value Current status of the storage account
     */
    @JvmName("ynnitotprfgjwayj")
    public fun storageAccountStatus(`value`: StorageAccountStatus) {
        val toBeMapped = Either.ofRight<String, StorageAccountStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountStatus = mapped
    }

    internal fun build(): StorageAccountArgs = StorageAccountArgs(
        dataPolicy = dataPolicy,
        description = description,
        deviceName = deviceName,
        resourceGroupName = resourceGroupName,
        storageAccountCredentialId = storageAccountCredentialId,
        storageAccountName = storageAccountName,
        storageAccountStatus = storageAccountStatus,
    )
}
