@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.StorageAccountCredentialArgs.builder
import com.pulumi.azurenative.databoxedge.kotlin.enums.AccountType
import com.pulumi.azurenative.databoxedge.kotlin.enums.SSLStatus
import com.pulumi.azurenative.databoxedge.kotlin.inputs.AsymmetricEncryptedSecretArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.AsymmetricEncryptedSecretArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The storage account credential.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-01-01-preview, 2023-07-01, 2023-12-01.
 * ## Example Usage
 * ### SACPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccountCredential = new AzureNative.DataBoxEdge.StorageAccountCredential("storageAccountCredential", new()
 *     {
 *         AccountKey = new AzureNative.DataBoxEdge.Inputs.AsymmetricEncryptedSecretArgs
 *         {
 *             EncryptionAlgorithm = "AES256",
 *             EncryptionCertThumbprint = "2A9D8D6BE51574B5461230AEF02F162C5F01AD31",
 *             Value = "lAeZEYi6rNP1/EyNaVUYmTSZEYyaIaWmwUsGwek0+xiZj54GM9Ue9/UA2ed/ClC03wuSit2XzM/cLRU5eYiFBwks23rGwiQOr3sruEL2a74EjPD050xYjA6M1I2hu/w2yjVHhn5j+DbXS4Xzi+rHHNZK3DgfDO3PkbECjPck+PbpSBjy9+6Mrjcld5DIZhUAeMlMHrFlg+WKRKB14o/og56u5/xX6WKlrMLEQ+y6E18dUwvWs2elTNoVO8PBE8SM/CfooX4AMNvaNdSObNBPdP+F6Lzc556nFNWXrBLRt0vC7s9qTiVRO4x/qCNaK/B4y7IqXMllwQFf4Np9UQ2ECA==",
 *         },
 *         AccountType = "BlobStorage",
 *         Alias = "sac1",
 *         DeviceName = "testedgedevice",
 *         Name = "sac1",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         SslStatus = "Disabled",
 *         UserName = "cisbvt",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewStorageAccountCredential(ctx, "storageAccountCredential", &databoxedge.StorageAccountCredentialArgs{
 * 			AccountKey: &databoxedge.AsymmetricEncryptedSecretArgs{
 * 				EncryptionAlgorithm:      pulumi.String("AES256"),
 * 				EncryptionCertThumbprint: pulumi.String("2A9D8D6BE51574B5461230AEF02F162C5F01AD31"),
 * 				Value:                    pulumi.String("lAeZEYi6rNP1/EyNaVUYmTSZEYyaIaWmwUsGwek0+xiZj54GM9Ue9/UA2ed/ClC03wuSit2XzM/cLRU5eYiFBwks23rGwiQOr3sruEL2a74EjPD050xYjA6M1I2hu/w2yjVHhn5j+DbXS4Xzi+rHHNZK3DgfDO3PkbECjPck+PbpSBjy9+6Mrjcld5DIZhUAeMlMHrFlg+WKRKB14o/og56u5/xX6WKlrMLEQ+y6E18dUwvWs2elTNoVO8PBE8SM/CfooX4AMNvaNdSObNBPdP+F6Lzc556nFNWXrBLRt0vC7s9qTiVRO4x/qCNaK/B4y7IqXMllwQFf4Np9UQ2ECA=="),
 * 			},
 * 			AccountType:       pulumi.String("BlobStorage"),
 * 			Alias:             pulumi.String("sac1"),
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			Name:              pulumi.String("sac1"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			SslStatus:         pulumi.String("Disabled"),
 * 			UserName:          pulumi.String("cisbvt"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.StorageAccountCredential;
 * import com.pulumi.azurenative.databoxedge.StorageAccountCredentialArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccountCredential = new StorageAccountCredential("storageAccountCredential", StorageAccountCredentialArgs.builder()
 *             .accountKey(Map.ofEntries(
 *                 Map.entry("encryptionAlgorithm", "AES256"),
 *                 Map.entry("encryptionCertThumbprint", "2A9D8D6BE51574B5461230AEF02F162C5F01AD31"),
 *                 Map.entry("value", "lAeZEYi6rNP1/EyNaVUYmTSZEYyaIaWmwUsGwek0+xiZj54GM9Ue9/UA2ed/ClC03wuSit2XzM/cLRU5eYiFBwks23rGwiQOr3sruEL2a74EjPD050xYjA6M1I2hu/w2yjVHhn5j+DbXS4Xzi+rHHNZK3DgfDO3PkbECjPck+PbpSBjy9+6Mrjcld5DIZhUAeMlMHrFlg+WKRKB14o/og56u5/xX6WKlrMLEQ+y6E18dUwvWs2elTNoVO8PBE8SM/CfooX4AMNvaNdSObNBPdP+F6Lzc556nFNWXrBLRt0vC7s9qTiVRO4x/qCNaK/B4y7IqXMllwQFf4Np9UQ2ECA==")
 *             ))
 *             .accountType("BlobStorage")
 *             .alias("sac1")
 *             .deviceName("testedgedevice")
 *             .name("sac1")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .sslStatus("Disabled")
 *             .userName("cisbvt")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:StorageAccountCredential sac1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/storageAccountCredentials/{name}
 * ```
 * @property accountKey Encrypted storage key.
 * @property accountType Type of storage accessed on the storage account.
 * @property alias Alias for the storage account.
 * @property blobDomainName Blob end point for private clouds.
 * @property connectionString Connection string for the storage account. Use this string if username and account key are not specified.
 * @property deviceName The device name.
 * @property name The storage account credential name.
 * @property resourceGroupName The resource group name.
 * @property sslStatus Signifies whether SSL needs to be enabled or not.
 * @property storageAccountId Id of the storage account.
 * @property userName Username for the storage account.
 */
public data class StorageAccountCredentialArgs(
    public val accountKey: Output<AsymmetricEncryptedSecretArgs>? = null,
    public val accountType: Output<Either<String, AccountType>>? = null,
    public val alias: Output<String>? = null,
    public val blobDomainName: Output<String>? = null,
    public val connectionString: Output<String>? = null,
    public val deviceName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sslStatus: Output<Either<String, SSLStatus>>? = null,
    public val storageAccountId: Output<String>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.StorageAccountCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.StorageAccountCredentialArgs =
        com.pulumi.azurenative.databoxedge.StorageAccountCredentialArgs.builder()
            .accountKey(accountKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .accountType(
                accountType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .alias(alias?.applyValue({ args0 -> args0 }))
            .blobDomainName(blobDomainName?.applyValue({ args0 -> args0 }))
            .connectionString(connectionString?.applyValue({ args0 -> args0 }))
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sslStatus(
                sslStatus?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .storageAccountId(storageAccountId?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageAccountCredentialArgs].
 */
@PulumiTagMarker
public class StorageAccountCredentialArgsBuilder internal constructor() {
    private var accountKey: Output<AsymmetricEncryptedSecretArgs>? = null

    private var accountType: Output<Either<String, AccountType>>? = null

    private var alias: Output<String>? = null

    private var blobDomainName: Output<String>? = null

    private var connectionString: Output<String>? = null

    private var deviceName: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sslStatus: Output<Either<String, SSLStatus>>? = null

    private var storageAccountId: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value Encrypted storage key.
     */
    @JvmName("cbuvkdsemhfmcenr")
    public suspend fun accountKey(`value`: Output<AsymmetricEncryptedSecretArgs>) {
        this.accountKey = value
    }

    /**
     * @param value Type of storage accessed on the storage account.
     */
    @JvmName("dbtupsdfmkstwown")
    public suspend fun accountType(`value`: Output<Either<String, AccountType>>) {
        this.accountType = value
    }

    /**
     * @param value Alias for the storage account.
     */
    @JvmName("akamehwvuemqseul")
    public suspend fun alias(`value`: Output<String>) {
        this.alias = value
    }

    /**
     * @param value Blob end point for private clouds.
     */
    @JvmName("whgwnaymjelxaunn")
    public suspend fun blobDomainName(`value`: Output<String>) {
        this.blobDomainName = value
    }

    /**
     * @param value Connection string for the storage account. Use this string if username and account key are not specified.
     */
    @JvmName("lyfohxpqktiyjgwi")
    public suspend fun connectionString(`value`: Output<String>) {
        this.connectionString = value
    }

    /**
     * @param value The device name.
     */
    @JvmName("aqglitsbbuvfutnw")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value The storage account credential name.
     */
    @JvmName("gsiyydpfliewxbbt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("nmvkihqaeconyqtp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Signifies whether SSL needs to be enabled or not.
     */
    @JvmName("ycspaclgfuiedmqw")
    public suspend fun sslStatus(`value`: Output<Either<String, SSLStatus>>) {
        this.sslStatus = value
    }

    /**
     * @param value Id of the storage account.
     */
    @JvmName("bgiibkooakcrxfhg")
    public suspend fun storageAccountId(`value`: Output<String>) {
        this.storageAccountId = value
    }

    /**
     * @param value Username for the storage account.
     */
    @JvmName("jhvoirdnyypuqgua")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Encrypted storage key.
     */
    @JvmName("tkvkfekvaovkpswg")
    public suspend fun accountKey(`value`: AsymmetricEncryptedSecretArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountKey = mapped
    }

    /**
     * @param argument Encrypted storage key.
     */
    @JvmName("dsspyaerkfvrnmda")
    public suspend fun accountKey(argument: suspend AsymmetricEncryptedSecretArgsBuilder.() -> Unit) {
        val toBeMapped = AsymmetricEncryptedSecretArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accountKey = mapped
    }

    /**
     * @param value Type of storage accessed on the storage account.
     */
    @JvmName("kxvpkmlhjsvgfwpp")
    public suspend fun accountType(`value`: Either<String, AccountType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountType = mapped
    }

    /**
     * @param value Type of storage accessed on the storage account.
     */
    @JvmName("jchbqihbupxwngny")
    public fun accountType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountType = mapped
    }

    /**
     * @param value Type of storage accessed on the storage account.
     */
    @JvmName("atupxxpaqmggpolj")
    public fun accountType(`value`: AccountType) {
        val toBeMapped = Either.ofRight<String, AccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountType = mapped
    }

    /**
     * @param value Alias for the storage account.
     */
    @JvmName("rukknumtfmoikqkp")
    public suspend fun alias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alias = mapped
    }

    /**
     * @param value Blob end point for private clouds.
     */
    @JvmName("exsmiirhiskpybrv")
    public suspend fun blobDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobDomainName = mapped
    }

    /**
     * @param value Connection string for the storage account. Use this string if username and account key are not specified.
     */
    @JvmName("lbpqbmtkdhnivdld")
    public suspend fun connectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value The device name.
     */
    @JvmName("vjgsdalfbakgmamq")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value The storage account credential name.
     */
    @JvmName("tcrunavvvtwtsprl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("orgjsocpbdkgnmib")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Signifies whether SSL needs to be enabled or not.
     */
    @JvmName("osqcsotrohlhiwnv")
    public suspend fun sslStatus(`value`: Either<String, SSLStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslStatus = mapped
    }

    /**
     * @param value Signifies whether SSL needs to be enabled or not.
     */
    @JvmName("agccvwgakpieoifn")
    public fun sslStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SSLStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sslStatus = mapped
    }

    /**
     * @param value Signifies whether SSL needs to be enabled or not.
     */
    @JvmName("qdmasriqqldcummb")
    public fun sslStatus(`value`: SSLStatus) {
        val toBeMapped = Either.ofRight<String, SSLStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sslStatus = mapped
    }

    /**
     * @param value Id of the storage account.
     */
    @JvmName("bcydicyspgqsdopl")
    public suspend fun storageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountId = mapped
    }

    /**
     * @param value Username for the storage account.
     */
    @JvmName("lyliqqpeudvlfbnv")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): StorageAccountCredentialArgs = StorageAccountCredentialArgs(
        accountKey = accountKey,
        accountType = accountType,
        alias = alias,
        blobDomainName = blobDomainName,
        connectionString = connectionString,
        deviceName = deviceName,
        name = name,
        resourceGroupName = resourceGroupName,
        sslStatus = sslStatus,
        storageAccountId = storageAccountId,
        userName = userName,
    )
}
