@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.kotlin.outputs.AsymmetricEncryptedSecretResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.ShareAccessRightResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.databoxedge.kotlin.outputs.AsymmetricEncryptedSecretResponse.Companion.toKotlin as asymmetricEncryptedSecretResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.ShareAccessRightResponse.Companion.toKotlin as shareAccessRightResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [User].
 */
@PulumiTagMarker
public class UserResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserArgs = UserArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserArgsBuilder.() -> Unit) {
        val builder = UserArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): User {
        val builtJavaResource = com.pulumi.azurenative.databoxedge.User(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return User(builtJavaResource)
    }
}

/**
 * Represents a user who has access to one or more shares on the Data Box Edge/Gateway device.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2019-07-01, 2019-08-01, 2021-02-01-preview, 2023-01-01-preview, 2023-07-01, 2023-12-01.
 * ## Example Usage
 * ### UserPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var user = new AzureNative.DataBoxEdge.User("user", new()
 *     {
 *         DeviceName = "testedgedevice",
 *         EncryptedPassword = new AzureNative.DataBoxEdge.Inputs.AsymmetricEncryptedSecretArgs
 *         {
 *             EncryptionAlgorithm = "None",
 *             EncryptionCertThumbprint = "blah",
 *             Value = "<value>",
 *         },
 *         Name = "user1",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         UserType = "Share",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewUser(ctx, "user", &databoxedge.UserArgs{
 * 			DeviceName: pulumi.String("testedgedevice"),
 * 			EncryptedPassword: &databoxedge.AsymmetricEncryptedSecretArgs{
 * 				EncryptionAlgorithm:      pulumi.String("None"),
 * 				EncryptionCertThumbprint: pulumi.String("blah"),
 * 				Value:                    pulumi.String("<value>"),
 * 			},
 * 			Name:              pulumi.String("user1"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			UserType:          pulumi.String("Share"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.User;
 * import com.pulumi.azurenative.databoxedge.UserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var user = new User("user", UserArgs.builder()
 *             .deviceName("testedgedevice")
 *             .encryptedPassword(Map.ofEntries(
 *                 Map.entry("encryptionAlgorithm", "None"),
 *                 Map.entry("encryptionCertThumbprint", "blah"),
 *                 Map.entry("value", "<value>")
 *             ))
 *             .name("user1")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .userType("Share")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:User user1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/users/{name}
 * ```
 */
public class User internal constructor(
    override val javaResource: com.pulumi.azurenative.databoxedge.User,
) : KotlinCustomResource(javaResource, UserMapper) {
    /**
     * The password details.
     */
    public val encryptedPassword: Output<AsymmetricEncryptedSecretResponse>?
        get() = javaResource.encryptedPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> asymmetricEncryptedSecretResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The object name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of shares that the user has rights on. This field should not be specified during user creation.
     */
    public val shareAccessRights: Output<List<ShareAccessRightResponse>>
        get() = javaResource.shareAccessRights().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> shareAccessRightResponseToKotlin(args0) })
            })
        })

    /**
     * Metadata pertaining to creation and last modification of User
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Type of the user.
     */
    public val userType: Output<String>
        get() = javaResource.userType().applyValue({ args0 -> args0 })
}

public object UserMapper : ResourceMapper<User> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databoxedge.User::class == javaResource::class

    override fun map(javaResource: Resource): User = User(
        javaResource as
            com.pulumi.azurenative.databoxedge.User,
    )
}

/**
 * @see [User].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [User].
 */
public suspend fun user(name: String, block: suspend UserResourceBuilder.() -> Unit): User {
    val builder = UserResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [User].
 * @param name The _unique_ name of the resulting resource.
 */
public fun user(name: String): User {
    val builder = UserResourceBuilder()
    builder.name(name)
    return builder.build()
}
