@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of storage accessed on the storage account.
 */
public enum class AccountType(
    public val javaValue: com.pulumi.azurenative.databoxedge.enums.AccountType,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.enums.AccountType> {
    GeneralPurposeStorage(com.pulumi.azurenative.databoxedge.enums.AccountType.GeneralPurposeStorage),
    BlobStorage(com.pulumi.azurenative.databoxedge.enums.AccountType.BlobStorage),
    ;

    override fun toJava(): com.pulumi.azurenative.databoxedge.enums.AccountType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.enums.AccountType): AccountType =
            AccountType.values().first { it.javaValue == javaType }
    }
}
