@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.AuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Authentication mechanism for IoT devices.
 * @property symmetricKey Symmetric key for authentication.
 */
public data class AuthenticationArgs(
    public val symmetricKey: Output<SymmetricKeyArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.AuthenticationArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.AuthenticationArgs =
        com.pulumi.azurenative.databoxedge.inputs.AuthenticationArgs.builder()
            .symmetricKey(symmetricKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AuthenticationArgs].
 */
@PulumiTagMarker
public class AuthenticationArgsBuilder internal constructor() {
    private var symmetricKey: Output<SymmetricKeyArgs>? = null

    /**
     * @param value Symmetric key for authentication.
     */
    @JvmName("extyfgmrjgvchfvv")
    public suspend fun symmetricKey(`value`: Output<SymmetricKeyArgs>) {
        this.symmetricKey = value
    }

    /**
     * @param value Symmetric key for authentication.
     */
    @JvmName("atknolhbbajvmaqs")
    public suspend fun symmetricKey(`value`: SymmetricKeyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.symmetricKey = mapped
    }

    /**
     * @param argument Symmetric key for authentication.
     */
    @JvmName("dshfvbokfmqqjsal")
    public suspend fun symmetricKey(argument: suspend SymmetricKeyArgsBuilder.() -> Unit) {
        val toBeMapped = SymmetricKeyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.symmetricKey = mapped
    }

    internal fun build(): AuthenticationArgs = AuthenticationArgs(
        symmetricKey = symmetricKey,
    )
}
