@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.AzureContainerInfoArgs.builder
import com.pulumi.azurenative.databoxedge.kotlin.enums.AzureContainerDataFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure container mapping of the endpoint.
 * @property containerName Container name (Based on the data format specified, this represents the name of Azure Files/Page blob/Block blob).
 * @property dataFormat Storage format used for the file represented by the share.
 * @property storageAccountCredentialId ID of the storage account credential used to access storage.
 */
public data class AzureContainerInfoArgs(
    public val containerName: Output<String>,
    public val dataFormat: Output<Either<String, AzureContainerDataFormat>>,
    public val storageAccountCredentialId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.AzureContainerInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.AzureContainerInfoArgs =
        com.pulumi.azurenative.databoxedge.inputs.AzureContainerInfoArgs.builder()
            .containerName(containerName.applyValue({ args0 -> args0 }))
            .dataFormat(
                dataFormat.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .storageAccountCredentialId(storageAccountCredentialId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureContainerInfoArgs].
 */
@PulumiTagMarker
public class AzureContainerInfoArgsBuilder internal constructor() {
    private var containerName: Output<String>? = null

    private var dataFormat: Output<Either<String, AzureContainerDataFormat>>? = null

    private var storageAccountCredentialId: Output<String>? = null

    /**
     * @param value Container name (Based on the data format specified, this represents the name of Azure Files/Page blob/Block blob).
     */
    @JvmName("kcicqpwnnelnssbs")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Storage format used for the file represented by the share.
     */
    @JvmName("hqgboavkgywxbwgo")
    public suspend fun dataFormat(`value`: Output<Either<String, AzureContainerDataFormat>>) {
        this.dataFormat = value
    }

    /**
     * @param value ID of the storage account credential used to access storage.
     */
    @JvmName("skamiehauegqlnqk")
    public suspend fun storageAccountCredentialId(`value`: Output<String>) {
        this.storageAccountCredentialId = value
    }

    /**
     * @param value Container name (Based on the data format specified, this represents the name of Azure Files/Page blob/Block blob).
     */
    @JvmName("yjhotqfqclcmrrtp")
    public suspend fun containerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Storage format used for the file represented by the share.
     */
    @JvmName("yjnijllsxpacwdwf")
    public suspend fun dataFormat(`value`: Either<String, AzureContainerDataFormat>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value Storage format used for the file represented by the share.
     */
    @JvmName("firefsamvwswypdk")
    public fun dataFormat(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureContainerDataFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value Storage format used for the file represented by the share.
     */
    @JvmName("npenyphrhrxjjbev")
    public fun dataFormat(`value`: AzureContainerDataFormat) {
        val toBeMapped = Either.ofRight<String, AzureContainerDataFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value ID of the storage account credential used to access storage.
     */
    @JvmName("xjrypgtucdatvvxi")
    public suspend fun storageAccountCredentialId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountCredentialId = mapped
    }

    internal fun build(): AzureContainerInfoArgs = AzureContainerInfoArgs(
        containerName = containerName ?: throw PulumiNullFieldException("containerName"),
        dataFormat = dataFormat ?: throw PulumiNullFieldException("dataFormat"),
        storageAccountCredentialId = storageAccountCredentialId ?: throw
            PulumiNullFieldException("storageAccountCredentialId"),
    )
}
