@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.FileSourceInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * File source details.
 * @property shareId File share ID.
 */
public data class FileSourceInfoArgs(
    public val shareId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.FileSourceInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.FileSourceInfoArgs =
        com.pulumi.azurenative.databoxedge.inputs.FileSourceInfoArgs.builder()
            .shareId(shareId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FileSourceInfoArgs].
 */
@PulumiTagMarker
public class FileSourceInfoArgsBuilder internal constructor() {
    private var shareId: Output<String>? = null

    /**
     * @param value File share ID.
     */
    @JvmName("cmglphvnjymqneqx")
    public suspend fun shareId(`value`: Output<String>) {
        this.shareId = value
    }

    /**
     * @param value File share ID.
     */
    @JvmName("wjuqmsoyebskhppv")
    public suspend fun shareId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.shareId = mapped
    }

    internal fun build(): FileSourceInfoArgs = FileSourceInfoArgs(
        shareId = shareId ?: throw PulumiNullFieldException("shareId"),
    )
}
