@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.GetArcAddonPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property addonName The addon name.
 * @property deviceName The device name.
 * @property resourceGroupName The resource group name.
 * @property roleName The role name.
 */
public data class GetArcAddonPlainArgs(
    public val addonName: String,
    public val deviceName: String,
    public val resourceGroupName: String,
    public val roleName: String,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.GetArcAddonPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.GetArcAddonPlainArgs =
        com.pulumi.azurenative.databoxedge.inputs.GetArcAddonPlainArgs.builder()
            .addonName(addonName.let({ args0 -> args0 }))
            .deviceName(deviceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .roleName(roleName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetArcAddonPlainArgs].
 */
@PulumiTagMarker
public class GetArcAddonPlainArgsBuilder internal constructor() {
    private var addonName: String? = null

    private var deviceName: String? = null

    private var resourceGroupName: String? = null

    private var roleName: String? = null

    /**
     * @param value The addon name.
     */
    @JvmName("raenijcaogifcmgi")
    public suspend fun addonName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.addonName = mapped
    }

    /**
     * @param value The device name.
     */
    @JvmName("sohvoujhnhckolia")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deviceName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("lgxeqedlriafhnuf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The role name.
     */
    @JvmName("dgwwkjderqsytwml")
    public suspend fun roleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.roleName = mapped
    }

    internal fun build(): GetArcAddonPlainArgs = GetArcAddonPlainArgs(
        addonName = addonName ?: throw PulumiNullFieldException("addonName"),
        deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        roleName = roleName ?: throw PulumiNullFieldException("roleName"),
    )
}
