@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.GetStorageAccountPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deviceName The device name.
 * @property resourceGroupName The resource group name.
 * @property storageAccountName The storage account name.
 */
public data class GetStorageAccountPlainArgs(
    public val deviceName: String,
    public val resourceGroupName: String,
    public val storageAccountName: String,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.GetStorageAccountPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.GetStorageAccountPlainArgs =
        com.pulumi.azurenative.databoxedge.inputs.GetStorageAccountPlainArgs.builder()
            .deviceName(deviceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .storageAccountName(storageAccountName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStorageAccountPlainArgs].
 */
@PulumiTagMarker
public class GetStorageAccountPlainArgsBuilder internal constructor() {
    private var deviceName: String? = null

    private var resourceGroupName: String? = null

    private var storageAccountName: String? = null

    /**
     * @param value The device name.
     */
    @JvmName("xcdnfbsuhphlinrd")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deviceName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("wqcyfqqlbjjugtlp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The storage account name.
     */
    @JvmName("kejblblgtlutakbd")
    public suspend fun storageAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageAccountName = mapped
    }

    internal fun build(): GetStorageAccountPlainArgs = GetStorageAccountPlainArgs(
        deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        storageAccountName = storageAccountName ?: throw PulumiNullFieldException("storageAccountName"),
    )
}
