@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.KubernetesClusterInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Kubernetes cluster configuration
 * @property version Kubernetes cluster version
 */
public data class KubernetesClusterInfoArgs(
    public val version: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.KubernetesClusterInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.KubernetesClusterInfoArgs =
        com.pulumi.azurenative.databoxedge.inputs.KubernetesClusterInfoArgs.builder()
            .version(version.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KubernetesClusterInfoArgs].
 */
@PulumiTagMarker
public class KubernetesClusterInfoArgsBuilder internal constructor() {
    private var version: Output<String>? = null

    /**
     * @param value Kubernetes cluster version
     */
    @JvmName("dcvcmickuwysespu")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Kubernetes cluster version
     */
    @JvmName("tdpdurflepmjagfo")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): KubernetesClusterInfoArgs = KubernetesClusterInfoArgs(
        version = version ?: throw PulumiNullFieldException("version"),
    )
}
