@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.MetricCounterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The metric counter
 * @property additionalDimensions The additional dimensions to be added to metric.
 * @property dimensionFilter The dimension filter.
 * @property instance The instance from which counter should be collected.
 * @property name The counter name.
 */
public data class MetricCounterArgs(
    public val additionalDimensions: Output<List<MetricDimensionArgs>>? = null,
    public val dimensionFilter: Output<List<MetricDimensionArgs>>? = null,
    public val instance: Output<String>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.MetricCounterArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.MetricCounterArgs =
        com.pulumi.azurenative.databoxedge.inputs.MetricCounterArgs.builder()
            .additionalDimensions(
                additionalDimensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dimensionFilter(
                dimensionFilter?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .instance(instance?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetricCounterArgs].
 */
@PulumiTagMarker
public class MetricCounterArgsBuilder internal constructor() {
    private var additionalDimensions: Output<List<MetricDimensionArgs>>? = null

    private var dimensionFilter: Output<List<MetricDimensionArgs>>? = null

    private var instance: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The additional dimensions to be added to metric.
     */
    @JvmName("trefrfnuktvmxxak")
    public suspend fun additionalDimensions(`value`: Output<List<MetricDimensionArgs>>) {
        this.additionalDimensions = value
    }

    @JvmName("gxnefiwqlapmeqao")
    public suspend fun additionalDimensions(vararg values: Output<MetricDimensionArgs>) {
        this.additionalDimensions = Output.all(values.asList())
    }

    /**
     * @param values The additional dimensions to be added to metric.
     */
    @JvmName("edwjlbuwrekglffk")
    public suspend fun additionalDimensions(values: List<Output<MetricDimensionArgs>>) {
        this.additionalDimensions = Output.all(values)
    }

    /**
     * @param value The dimension filter.
     */
    @JvmName("qkevqcshwwefciui")
    public suspend fun dimensionFilter(`value`: Output<List<MetricDimensionArgs>>) {
        this.dimensionFilter = value
    }

    @JvmName("bqspyuphfhidslps")
    public suspend fun dimensionFilter(vararg values: Output<MetricDimensionArgs>) {
        this.dimensionFilter = Output.all(values.asList())
    }

    /**
     * @param values The dimension filter.
     */
    @JvmName("vvuvbtmqkvjsmfap")
    public suspend fun dimensionFilter(values: List<Output<MetricDimensionArgs>>) {
        this.dimensionFilter = Output.all(values)
    }

    /**
     * @param value The instance from which counter should be collected.
     */
    @JvmName("qawrkumfsnobvcqi")
    public suspend fun instance(`value`: Output<String>) {
        this.instance = value
    }

    /**
     * @param value The counter name.
     */
    @JvmName("egfoumqbklphduva")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The additional dimensions to be added to metric.
     */
    @JvmName("fjqsviudvpmtrwqs")
    public suspend fun additionalDimensions(`value`: List<MetricDimensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalDimensions = mapped
    }

    /**
     * @param argument The additional dimensions to be added to metric.
     */
    @JvmName("akptbvlqpkcwslta")
    public suspend
    fun additionalDimensions(argument: List<suspend MetricDimensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetricDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalDimensions = mapped
    }

    /**
     * @param argument The additional dimensions to be added to metric.
     */
    @JvmName("fnejoejeoxpeedvv")
    public suspend fun additionalDimensions(
        vararg
        argument: suspend MetricDimensionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MetricDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalDimensions = mapped
    }

    /**
     * @param argument The additional dimensions to be added to metric.
     */
    @JvmName("wnhrdisufxpqcbxh")
    public suspend fun additionalDimensions(argument: suspend MetricDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MetricDimensionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.additionalDimensions = mapped
    }

    /**
     * @param values The additional dimensions to be added to metric.
     */
    @JvmName("sehwvybnwxxteqxc")
    public suspend fun additionalDimensions(vararg values: MetricDimensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalDimensions = mapped
    }

    /**
     * @param value The dimension filter.
     */
    @JvmName("yphvowlwwerpraui")
    public suspend fun dimensionFilter(`value`: List<MetricDimensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensionFilter = mapped
    }

    /**
     * @param argument The dimension filter.
     */
    @JvmName("ogiclhjneljpbfsn")
    public suspend
    fun dimensionFilter(argument: List<suspend MetricDimensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetricDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensionFilter = mapped
    }

    /**
     * @param argument The dimension filter.
     */
    @JvmName("hphhctdusjdlgeba")
    public suspend fun dimensionFilter(
        vararg
        argument: suspend MetricDimensionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MetricDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensionFilter = mapped
    }

    /**
     * @param argument The dimension filter.
     */
    @JvmName("lnunfpddcagugtkq")
    public suspend fun dimensionFilter(argument: suspend MetricDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MetricDimensionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dimensionFilter = mapped
    }

    /**
     * @param values The dimension filter.
     */
    @JvmName("kgtdtcqvejofxyrq")
    public suspend fun dimensionFilter(vararg values: MetricDimensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensionFilter = mapped
    }

    /**
     * @param value The instance from which counter should be collected.
     */
    @JvmName("pfqnmwxtovbxljqr")
    public suspend fun instance(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instance = mapped
    }

    /**
     * @param value The counter name.
     */
    @JvmName("ymjknqkqsysqdtpv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): MetricCounterArgs = MetricCounterArgs(
        additionalDimensions = additionalDimensions,
        dimensionFilter = dimensionFilter,
        instance = instance,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
