@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.ResourceIdentityArgs.builder
import com.pulumi.azurenative.databoxedge.kotlin.enums.MsiIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Msi identity details of the resource
 * @property type Identity type
 */
public data class ResourceIdentityArgs(
    public val type: Output<Either<String, MsiIdentityType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.ResourceIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.ResourceIdentityArgs =
        com.pulumi.azurenative.databoxedge.inputs.ResourceIdentityArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ResourceIdentityArgs].
 */
@PulumiTagMarker
public class ResourceIdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, MsiIdentityType>>? = null

    /**
     * @param value Identity type
     */
    @JvmName("ievefgmjatmyejjg")
    public suspend fun type(`value`: Output<Either<String, MsiIdentityType>>) {
        this.type = value
    }

    /**
     * @param value Identity type
     */
    @JvmName("lwsrxcgjuuubommd")
    public suspend fun type(`value`: Either<String, MsiIdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Identity type
     */
    @JvmName("wggfoddbbhtxaujf")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MsiIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Identity type
     */
    @JvmName("ehbewqxlgutijtkq")
    public fun type(`value`: MsiIdentityType) {
        val toBeMapped = Either.ofRight<String, MsiIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ResourceIdentityArgs = ResourceIdentityArgs(
        type = type,
    )
}
